/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules;

import sisc.data.Quantity;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;

public class Logical
extends IndexedFixableProcedure {
    protected static final Symbol LOGICOPSB = Symbol.intern((String)"sisc.modules.Messages");
    protected static final int LOGAND = 1;
    protected static final int LOGOR = 2;
    protected static final int LOGXOR = 3;
    protected static final int LOGNOT = 4;
    protected static final int LOGCOUNT = 5;

    public Logical(int n) {
        super(n);
    }

    public Logical() {
    }

    public Value apply(Value value) throws ContinuationException {
        switch (this.id) {
            case 4: {
                return Logical.num((Value)value).not();
            }
            case 5: {
                return Logical.num((Value)value).bitCount();
            }
            case 1: 
            case 2: 
            case 3: {
                return Logical.num((Value)value);
            }
        }
        Logical.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value value, Value value2) throws ContinuationException {
        switch (this.id) {
            case 1: {
                return Logical.num((Value)value).and(Logical.num((Value)value2));
            }
            case 2: {
                return Logical.num((Value)value).or(Logical.num((Value)value2));
            }
            case 3: {
                return Logical.num((Value)value).xor(Logical.num((Value)value2));
            }
        }
        Logical.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value value, Value value2, Value value3) throws ContinuationException {
        switch (this.id) {
            case 1: {
                return Logical.num((Value)value).and(Logical.num((Value)value2)).and(Logical.num((Value)value3));
            }
            case 2: {
                return Logical.num((Value)value).or(Logical.num((Value)value2)).or(Logical.num((Value)value3));
            }
            case 3: {
                return Logical.num((Value)value).xor(Logical.num((Value)value2)).xor(Logical.num((Value)value3));
            }
        }
        Logical.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value[] valueArray) throws ContinuationException {
        Quantity quantity = Logical.num((Value)valueArray[0]);
        switch (this.id) {
            case 1: {
                for (int i = valueArray.length - 1; i > 0; --i) {
                    quantity = quantity.and(Logical.num((Value)valueArray[i]));
                }
                break;
            }
            case 2: {
                for (int i = valueArray.length - 1; i > 0; --i) {
                    quantity = quantity.or(Logical.num((Value)valueArray[i]));
                }
                break;
            }
            case 3: {
                for (int i = valueArray.length - 1; i > 0; --i) {
                    quantity = quantity.xor(Logical.num((Value)valueArray[i]));
                }
                break;
            }
        }
        return quantity;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new Logical(n);
        }

        public Index() {
            this.define("logand", 1);
            this.define("logor", 2);
            this.define("logxor", 3);
            this.define("lognot", 4);
            this.define("logcount", 5);
        }
    }
}

