/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.hashtable;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.modules.Threads;
import sisc.modules.hashtable.HashtableBase;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class SynchronizedHashtable
extends HashtableBase {
    private HashtableBase delegate;

    public SynchronizedHashtable() {
    }

    public SynchronizedHashtable(HashtableBase hashtableBase) {
        this.delegate = hashtableBase;
    }

    public HashtableBase getDelegate() {
        return this.delegate;
    }

    public Procedure getEqualsProc() {
        return this.delegate.getEqualsProc();
    }

    public Procedure getHashProc() {
        return this.delegate.getHashProc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value get(Value value) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            Value value2 = this.delegate.get(value);
            return value2;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value put(Value value, Value value2) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            Value value3 = this.delegate.put(value, value2);
            return value3;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value remove(Value value) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            Value value2 = this.delegate.remove(value);
            return value2;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            this.delegate.clear();
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAList(Pair pair) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            this.delegate.addAList(pair);
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair toAList() {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            Pair pair = this.delegate.toAList();
            return pair;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair keys() {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            Pair pair = this.delegate.keys();
            return pair;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEqual(Value value) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            boolean bl = this.delegate.valueEqual(value);
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int valueHashCode() {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            int n = this.delegate.valueHashCode();
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Serializer serializer) throws IOException {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            serializer.writeExpression((Expression)this.delegate);
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(Deserializer deserializer) throws IOException {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            this.delegate = (HashtableBase)deserializer.readExpression();
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visit(ExpressionVisitor expressionVisitor) {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            boolean bl = this.delegate.visit(expressionVisitor);
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(ValueWriter valueWriter) throws IOException {
        Threads.Mutex mutex = Threads.Mutex.of(this);
        mutex.acquire();
        try {
            this.delegate.display(valueWriter);
        }
        finally {
            mutex.unlock();
        }
    }
}

