/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import sisc.data.Quantity;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.BinaryInputPort;
import sisc.io.BinaryOutputPort;
import sisc.io.StreamInputPort;
import sisc.io.StreamOutputPort;
import sisc.modules.io.Buffer;
import sisc.modules.io.IO;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;

public class BinaryIO
extends IndexedProcedure {
    protected static Symbol BINARYB = Symbol.intern((String)"sisc.modules.io.Messages");
    protected static final int BLOCKREAD = 1;
    protected static final int BLOCKWRITE = 2;
    protected static final int MAKEBUFFER = 3;
    protected static final int BUFFERQ = 4;
    protected static final int BUFFERLENGTH = 5;
    protected static final int BUFFERREF = 6;
    protected static final int BUFFERSET = 7;
    protected static final int BUFFERCOPY = 8;
    protected static final int OPENBINARYINPUTFILE = 9;
    protected static final int OPENBINARYOUTPUTFILE = 10;
    protected static final int BINARYINPUTPORTQ = 11;
    protected static final int BINARYOUTPUTPORTQ = 12;
    protected static final int OPENINPUTBUFFER = 13;
    protected static final int OPENOUTPUTBUFFER = 14;
    protected static final int GETOUTPUTBUFFER = 15;

    public static final BinaryInputPort binport(Value value) {
        try {
            return (BinaryInputPort)value;
        }
        catch (ClassCastException classCastException) {
            BinaryIO.typeError((Symbol)BINARYB, (String)"binput-port", (Value)value);
            return null;
        }
    }

    public static final BinaryOutputPort boutport(Value value) {
        try {
            return (BinaryOutputPort)value;
        }
        catch (ClassCastException classCastException) {
            BinaryIO.typeError((Symbol)BINARYB, (String)"boutput-port", (Value)value);
            return null;
        }
    }

    private static StreamInputPort openBinInFile(Interpreter interpreter, URL uRL) throws ContinuationException {
        try {
            return new StreamInputPort((InputStream)new BufferedInputStream(IO.getURLInputStream((URL)uRL)));
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)BinaryIO.liMessage((Symbol)IO.IOB, (String)"erroropening", (String)uRL.toString()), (IOException)iOException);
            return null;
        }
    }

    private static StreamOutputPort openBinOutFile(Interpreter interpreter, URL uRL, boolean bl) throws ContinuationException {
        try {
            return new StreamOutputPort((OutputStream)new BufferedOutputStream(IO.getURLOutputStream((URL)uRL)), bl);
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)BinaryIO.liMessage((Symbol)IO.IOB, (String)"erroropening", (String)uRL.toString()), (IOException)iOException);
            return null;
        }
    }

    public BinaryIO(int n) {
        super(n);
    }

    public BinaryIO() {
    }

    static final Buffer buffer(Value value) throws ContinuationException {
        try {
            return (Buffer)value;
        }
        catch (ClassCastException classCastException) {
            BinaryIO.typeError((Symbol)BINARYB, (String)"buffer", (Value)value);
            return null;
        }
    }

    public Value doApply(Interpreter interpreter) throws ContinuationException {
        switch (interpreter.vlr.length) {
            case 0: {
                switch (this.id) {
                    case 14: {
                        return new StreamOutputPort((OutputStream)new ByteArrayOutputStream(), false);
                    }
                }
                BinaryIO.throwArgSizeException();
            }
            case 1: {
                switch (this.id) {
                    case 3: {
                        return new Buffer(BinaryIO.num((Value)interpreter.vlr[0]).indexValue());
                    }
                    case 5: {
                        return Quantity.valueOf((int)BinaryIO.buffer((Value)interpreter.vlr[0]).buf.length);
                    }
                    case 4: {
                        return BinaryIO.truth((boolean)(interpreter.vlr[0] instanceof Buffer));
                    }
                    case 15: {
                        StreamOutputPort streamOutputPort = (StreamOutputPort)interpreter.vlr[0];
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)streamOutputPort.out;
                        try {
                            streamOutputPort.flush();
                        }
                        catch (IOException iOException) {
                            BinaryIO.throwPrimException((String)BinaryIO.liMessage((Symbol)BINARYB, (String)"errorflushing", (String)streamOutputPort.toString(), (String)iOException.getMessage()));
                        }
                        Buffer buffer = new Buffer(byteArrayOutputStream.toByteArray());
                        byteArrayOutputStream.reset();
                        return buffer;
                    }
                    case 9: {
                        return BinaryIO.openBinInFile(interpreter, BinaryIO.url((Value)interpreter.vlr[0]));
                    }
                    case 10: {
                        return BinaryIO.openBinOutFile(interpreter, BinaryIO.url((Value)interpreter.vlr[0]), false);
                    }
                    case 13: {
                        return new StreamInputPort((InputStream)new ByteArrayInputStream(BinaryIO.buffer((Value)interpreter.vlr[0]).buf));
                    }
                    case 14: {
                        return new StreamOutputPort((OutputStream)new ByteArrayOutputStream(BinaryIO.num((Value)interpreter.vlr[0]).indexValue()), false);
                    }
                    case 11: {
                        return BinaryIO.truth((boolean)(interpreter.vlr[0] instanceof BinaryInputPort));
                    }
                    case 12: {
                        return BinaryIO.truth((boolean)(interpreter.vlr[0] instanceof BinaryOutputPort));
                    }
                }
                BinaryIO.throwArgSizeException();
            }
            case 2: {
                switch (this.id) {
                    case 3: {
                        return new Buffer(BinaryIO.num((Value)interpreter.vlr[0]).indexValue(), (byte)BinaryIO.num((Value)interpreter.vlr[1]).indexValue());
                    }
                    case 6: {
                        int n = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        try {
                            return Quantity.valueOf((int)(BinaryIO.buffer(interpreter.vlr[0]).ref(n) & 0xFF));
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            BinaryIO.throwPrimException((String)BinaryIO.liMessage((Symbol)SISCB, (String)"indexoob", (Object[])new Object[]{new Integer(n), interpreter.vlr[0].synopsis()}));
                        }
                    }
                    case 10: {
                        return BinaryIO.openBinOutFile(interpreter, BinaryIO.url((Value)interpreter.vlr[0]), BinaryIO.truth((Value)interpreter.vlr[1]));
                    }
                }
                BinaryIO.throwArgSizeException();
            }
            case 3: {
                switch (this.id) {
                    case 7: {
                        int n = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        try {
                            BinaryIO.buffer(interpreter.vlr[0]).set(n, (byte)BinaryIO.num((Value)interpreter.vlr[2]).indexValue());
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            BinaryIO.throwPrimException((String)BinaryIO.liMessage((Symbol)SISCB, (String)"indexoob", (Object[])new Object[]{new Integer(n), interpreter.vlr[0].synopsis()}));
                        }
                        return VOID;
                    }
                }
                BinaryIO.throwArgSizeException();
            }
            case 4: {
                switch (this.id) {
                    case 1: {
                        int n = BinaryIO.num((Value)interpreter.vlr[2]).indexValue();
                        int n2 = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        BinaryInputPort binaryInputPort = BinaryIO.binport(interpreter.vlr[3]);
                        byte[] byArray = BinaryIO.buffer((Value)interpreter.vlr[0]).buf;
                        try {
                            int n3 = binaryInputPort.read(byArray, n2, Math.min(byArray.length - n2, n));
                            if (n3 == -1) {
                                return EOF;
                            }
                            return Quantity.valueOf((int)n3);
                        }
                        catch (IOException iOException) {
                            BinaryIO.error((Interpreter)interpreter, (String)BinaryIO.liMessage((Symbol)BINARYB, (String)"errorreading", (String)binaryInputPort.toString(), (String)iOException.getMessage()));
                            break;
                        }
                    }
                    case 2: {
                        int n = BinaryIO.num((Value)interpreter.vlr[2]).indexValue();
                        int n4 = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        BinaryOutputPort binaryOutputPort = BinaryIO.boutport(interpreter.vlr[3]);
                        byte[] byArray = BinaryIO.buffer((Value)interpreter.vlr[0]).buf;
                        try {
                            binaryOutputPort.write(byArray, 0, n);
                        }
                        catch (IOException iOException) {
                            BinaryIO.error((Interpreter)interpreter, (String)BinaryIO.liMessage((Symbol)BINARYB, (String)"errorwriting", (String)binaryOutputPort.toString(), (String)iOException.getMessage()));
                        }
                        return VOID;
                    }
                    case 8: {
                        byte[] byArray = BinaryIO.buffer((Value)interpreter.vlr[0]).buf;
                        byte[] byArray2 = BinaryIO.buffer((Value)interpreter.vlr[2]).buf;
                        int n = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        int n5 = BinaryIO.num((Value)interpreter.vlr[3]).indexValue();
                        int n6 = byArray.length;
                        try {
                            System.arraycopy(byArray, n, byArray2, n5, n6);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            BinaryIO.throwPrimException((String)BinaryIO.liMessage((Symbol)BINARYB, (String)"bufferoverrun", (String)interpreter.vlr[0].synopsis(), (String)interpreter.vlr[2].synopsis()));
                        }
                        return VOID;
                    }
                    default: {
                        BinaryIO.throwArgSizeException();
                    }
                }
            }
            case 5: {
                switch (this.id) {
                    case 8: {
                        byte[] byArray = BinaryIO.buffer((Value)interpreter.vlr[0]).buf;
                        byte[] byArray3 = BinaryIO.buffer((Value)interpreter.vlr[2]).buf;
                        int n = BinaryIO.num((Value)interpreter.vlr[1]).indexValue();
                        int n7 = BinaryIO.num((Value)interpreter.vlr[3]).indexValue();
                        int n8 = BinaryIO.num((Value)interpreter.vlr[4]).indexValue();
                        try {
                            System.arraycopy(byArray, n, byArray3, n7, n8);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            BinaryIO.throwPrimException((String)BinaryIO.liMessage((Symbol)BINARYB, (String)"bufferoverrun", (String)interpreter.vlr[0].synopsis(), (String)interpreter.vlr[2].synopsis()));
                        }
                        return VOID;
                    }
                }
                BinaryIO.throwArgSizeException();
            }
        }
        BinaryIO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new BinaryIO(n);
        }

        public Index() {
            this.define("read-block", 1);
            this.define("write-block", 2);
            this.define("make-buffer", 3);
            this.define("buffer?", 4);
            this.define("buffer-length", 5);
            this.define("buffer-ref", 6);
            this.define("buffer-set!", 7);
            this.define("buffer-copy!", 8);
            this.define("get-output-buffer", 15);
            this.define("open-binary-input-file", 9);
            this.define("open-binary-output-file", 10);
            this.define("open-input-buffer", 13);
            this.define("open-output-buffer", 14);
            this.define("binary-input-port?", 11);
            this.define("binary-output-port?", 12);
        }
    }
}

