/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import sisc.data.Pair;
import sisc.data.Singleton;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.JavaDeserializer;
import sisc.ser.JavaSerializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public abstract class Expression
extends Util
implements Externalizable,
ExpressionVisitee {
    protected static Set EMPTYSET = new TreeSet();
    public Map annotations;

    public synchronized Value getAnnotation(Symbol symbol, Value value) {
        if (this.annotations == null) {
            return value;
        }
        Value value2 = (Value)this.annotations.get(symbol);
        return value2 == null ? value : value2;
    }

    public Value getAnnotation(Symbol symbol) {
        return this.getAnnotation(symbol, FALSE);
    }

    public synchronized Value setAnnotation(Symbol symbol, Value value, Value value2) {
        Value value3;
        if (this.annotations == null) {
            this.annotations = new HashMap(0);
        }
        return (value3 = this.annotations.put(symbol, value)) == null ? value2 : value3;
    }

    public Value setAnnotation(Symbol symbol, Value value) {
        return this.setAnnotation(symbol, value, FALSE);
    }

    public synchronized Set getAnnotationKeys() {
        if (this.annotations == null) {
            return EMPTYSET;
        }
        return this.annotations.keySet();
    }

    public synchronized Pair getAnnotations() {
        Pair pair = EMPTYLIST;
        if (this.annotations == null) {
            return pair;
        }
        Iterator iterator = this.annotations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            pair = new Pair(new Pair((Value)entry.getKey(), (Value)entry.getValue()), pair);
        }
        return pair;
    }

    public void serializeAnnotations(Serializer serializer) throws IOException {
        if (this.annotations == null) {
            serializer.writeInt(0);
        } else {
            serializer.writeInt(this.annotations.size());
            Iterator iterator = this.annotations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                serializer.writeExpression((Expression)entry.getKey());
                serializer.writeExpression((Expression)entry.getValue());
            }
        }
    }

    public void deserializeAnnotations(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        if (n == 0) {
            return;
        }
        this.annotations = new HashMap(n);
        while (n > 0) {
            Expression expression = deserializer.readExpression();
            Expression expression2 = deserializer.readExpression();
            this.annotations.put(expression, expression2);
            --n;
        }
    }

    public boolean visitAnnotations(ExpressionVisitor expressionVisitor) {
        if (this.annotations == null) {
            return true;
        }
        Iterator iterator = this.annotations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!expressionVisitor.visit((Expression)entry.getKey())) {
                return false;
            }
            if (expressionVisitor.visit((Expression)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public void setName(Symbol symbol) {
        this.setAnnotation(NAME, symbol);
    }

    public Symbol getName() {
        return (Symbol)this.getAnnotation(NAME, null);
    }

    public abstract void eval(Interpreter var1) throws ContinuationException;

    public Value getValue(Interpreter interpreter) throws ContinuationException, OptimismUnwarrantedException {
        return null;
    }

    public abstract Value express();

    public void serialize(Serializer serializer) throws IOException {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serializer serializer = JavaSerializer.create(objectOutput);
        this.serialize(serializer);
        this.serializeAnnotations(serializer);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        Deserializer deserializer = JavaDeserializer.create(objectInput);
        this.deserialize(deserializer);
        this.deserializeAnnotations(deserializer);
    }

    public Object readResolve() throws ObjectStreamException {
        return this instanceof Singleton ? ((Singleton)((Object)this)).singletonValue() : this;
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return true;
    }
}

