/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.SchemeVector;
import sisc.data.Value;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class ImmutableVector
extends SchemeVector {
    private boolean isImmutable = true;

    public ImmutableVector() {
    }

    public ImmutableVector(int n) {
        super(n);
    }

    public ImmutableVector(int n, boolean bl) {
        super(n);
        this.isImmutable = bl;
    }

    public ImmutableVector(int n, Value value) {
        super(n, value);
    }

    public ImmutableVector(Value[] valueArray) {
        super(valueArray);
    }

    public void set(int n, Value value) {
        if (this.isImmutable) {
            throw new RuntimeException(ImmutableVector.liMessage(SISCB, "vectorisimmutable"));
        }
        super.set(n, value);
    }

    public void fill(Value value) {
        if (this.isImmutable) {
            throw new RuntimeException(ImmutableVector.liMessage(SISCB, "vectorisimmutable"));
        }
        super.fill(value);
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public void makeImmutable() {
        this.isImmutable = true;
    }

    public void serialize(Serializer serializer) throws IOException {
        super.serialize(serializer);
        serializer.writeBoolean(this.isImmutable);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        super.deserialize(deserializer);
        this.isImmutable = deserializer.readBoolean();
    }
}

