/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class AnnotatedExpr
extends Value
implements OptimisticHost {
    public Expression expr;
    public Value annotation;
    public Value stripped = FALSE;

    public AnnotatedExpr(Expression expression, Value value) {
        this.expr = expression;
        this.annotation = value;
    }

    public void setHosts() {
        Utils.linkOptimistic(this, this.expr, 0);
    }

    public final void eval(Interpreter interpreter) throws ContinuationException {
        this.expr.eval(interpreter);
    }

    public final Value getValue(Interpreter interpreter) throws ContinuationException {
        try {
            return this.expr.getValue(interpreter);
        }
        catch (OptimismUnwarrantedException optimismUnwarrantedException) {
            return this.getValue(interpreter);
        }
    }

    public Value express() {
        return AnnotatedExpr.list(AnnotatedExpr.sym("Annotated-expr"), this.annotation, this.expr.express());
    }

    public AnnotatedExpr() {
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.expr);
        serializer.writeExpression(this.annotation);
        serializer.writeExpression(this.stripped);
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#@(").append(this.annotation).append(" . ");
        if (this.expr instanceof Value) {
            valueWriter.append((Value)this.expr);
        } else {
            valueWriter.append(this.expr.express());
        }
        valueWriter.append(')');
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.expr = deserializer.readExpression();
        this.annotation = (Value)deserializer.readExpression();
        this.stripped = (Value)deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.expr) && expressionVisitor.visit(this.annotation) && expressionVisitor.visit(this.stripped);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        this.expr = expression;
    }
}

