/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.exprs.fp.OptimisticHost;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;
import sisc.util.FreeReference;
import sisc.util.UndefinedVarException;

public class FreeReferenceExp
extends Expression
implements Immediate {
    private FreeReference ref;
    private OptimisticHost host;
    private int uexpPosition;

    public FreeReferenceExp(FreeReference freeReference) {
        this.ref = freeReference;
    }

    public FreeReferenceExp(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this(new FreeReference(symbol, symbolicEnvironment));
    }

    public Symbol getSym() {
        return this.ref.getName();
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        interpreter.acc = this.getValue(interpreter);
        interpreter.nxp = null;
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        try {
            return this.ref.getValue();
        }
        catch (UndefinedVarException undefinedVarException) {
            FreeReferenceExp.error(interpreter, FreeReferenceExp.liMessage(SISCB, "undefinedvar", undefinedVarException.var));
            return null;
        }
    }

    public void serialize(Serializer serializer) throws IOException {
        this.ref.serialize(serializer);
    }

    public Value express() {
        return FreeReferenceExp.list(FreeReferenceExp.sym("FreeReference-exp"), this.ref.getName());
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.ref.deserialize(deserializer);
    }

    public FreeReferenceExp() {
        this.ref = new FreeReference();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FreeReferenceExp)) {
            return false;
        }
        FreeReferenceExp freeReferenceExp = (FreeReferenceExp)object;
        return this.ref.equals(freeReferenceExp.ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return this.ref.visit(expressionVisitor);
    }

    public FreeReference getReference() {
        return this.ref;
    }
}

