/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class IfEval
extends Expression
implements OptimisticHost {
    private static final int POS_CONSEQ = 0;
    private static final int POS_ALTERN = 1;
    public Expression conseq;
    public Expression altern;

    public IfEval(Expression expression, Expression expression2) {
        this.conseq = expression;
        this.altern = expression2;
    }

    public void setHosts() {
        Utils.linkOptimistic(this, this.conseq, 0);
        Utils.linkOptimistic(this, this.altern, 1);
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        try {
            interpreter.next(IfEval.truth(interpreter.acc) ? this.conseq : this.altern);
        }
        catch (OptimismUnwarrantedException optimismUnwarrantedException) {
            interpreter.nxp = this;
        }
    }

    public Value express() {
        return IfEval.list(IfEval.sym("If-eval"), this.conseq.express(), this.altern.express());
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.conseq);
        serializer.writeExpression(this.altern);
    }

    public IfEval() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.conseq = deserializer.readExpression();
        this.altern = deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.conseq) && expressionVisitor.visit(this.altern);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        switch (n) {
            case 0: {
                this.conseq = expression;
                break;
            }
            case 1: {
                this.altern = expression;
            }
        }
    }
}

