/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.data.Values;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class CallFrame
extends Procedure {
    public Expression nxp;
    public Value[] vlr;
    public Value[] lcl;
    public Value[] env;
    public boolean vlk;
    public CallFrame fk;
    public CallFrame parent;
    public SymbolicEnvironment tpl;

    public CallFrame(Expression expression, Value[] valueArray, boolean bl, Value[] valueArray2, Value[] valueArray3, SymbolicEnvironment symbolicEnvironment, CallFrame callFrame, CallFrame callFrame2) {
        this.nxp = expression;
        this.vlr = valueArray;
        this.vlk = bl;
        this.lcl = valueArray2;
        this.env = valueArray3;
        this.tpl = symbolicEnvironment;
        this.fk = callFrame;
        this.parent = callFrame2;
    }

    public final void init(Expression expression, Value[] valueArray, boolean bl, Value[] valueArray2, Value[] valueArray3, SymbolicEnvironment symbolicEnvironment, CallFrame callFrame, CallFrame callFrame2) {
        this.nxp = expression;
        this.vlr = valueArray;
        this.vlk = bl;
        this.lcl = valueArray2;
        this.env = valueArray3;
        this.tpl = symbolicEnvironment;
        this.fk = callFrame;
        this.parent = callFrame2;
    }

    public final void clear() {
        this.env = null;
        this.lcl = null;
        this.vlr = null;
        this.parent = null;
        this.fk = null;
        this.tpl = null;
    }

    public final CallFrame capture(Interpreter interpreter) {
        CallFrame callFrame = this;
        while (callFrame != null && !callFrame.vlk) {
            callFrame.vlk = true;
            callFrame = callFrame.parent;
        }
        return this;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        this.displayNamedOpaque(valueWriter, "continuation");
    }

    public static boolean visitValueArray(ExpressionVisitor expressionVisitor, Value[] valueArray) {
        if (valueArray == null) {
            return true;
        }
        for (int i = 0; i < valueArray.length; ++i) {
            if (expressionVisitor.visit(valueArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return CallFrame.visitValueArray(expressionVisitor, this.vlr) && CallFrame.visitValueArray(expressionVisitor, this.lcl) && CallFrame.visitValueArray(expressionVisitor, this.env) && expressionVisitor.visit(this.tpl) && expressionVisitor.visit(this.nxp) && expressionVisitor.visit(this.fk) && expressionVisitor.visit(this.parent);
    }

    public void apply(Interpreter interpreter) throws ContinuationException {
        interpreter.acc = interpreter.vlr.length == 1 ? interpreter.vlr[0] : new Values(interpreter.vlr);
        interpreter.pop(this);
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeBoolean(this.vlk);
        if (this.vlr == null) {
            serializer.writeBoolean(false);
        } else {
            serializer.writeBoolean(true);
            serializer.writeExpressionArray(this.vlr);
        }
        serializer.writeExpressionArray(this.lcl);
        serializer.writeExpressionArray(this.env);
        serializer.writeSymbolicEnvironment(this.tpl);
        serializer.writeExpression(this.nxp);
        serializer.writeExpression(this.fk);
        serializer.writeExpression(this.parent);
    }

    public CallFrame() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.vlk = deserializer.readBoolean();
        this.vlr = null;
        if (deserializer.readBoolean()) {
            this.vlr = deserializer.readValueArray();
        }
        this.lcl = deserializer.readValueArray();
        this.env = deserializer.readValueArray();
        this.tpl = deserializer.readSymbolicEnvironment();
        this.nxp = deserializer.readExpression();
        this.fk = (CallFrame)deserializer.readExpression();
        this.parent = (CallFrame)deserializer.readExpression();
    }
}

