/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.StringReader;
import sisc.compiler.Compiler;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.data.Values;
import sisc.env.DynamicEnvironment;
import sisc.env.MemorySymEnv;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.ApplyParentFrame;
import sisc.interpreter.CallFrame;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.SchemeException;
import sisc.interpreter.SchemeRuntimeException;
import sisc.interpreter.ThreadContext;
import sisc.io.InputPort;
import sisc.io.ReaderInputPort;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.Util;

public class Interpreter
extends Util {
    private static final Expression EVAL_APPEVAL = Interpreter.annotatedAppEval("eval");
    public static Compiler compiler = new Compiler();
    public ThreadContext tctx;
    public DynamicEnvironment dynenv;
    private boolean saveVLR;
    public Value[][] IAI = new Value[][]{new Value[1], new Value[2], new Value[3]};
    private boolean vlk;
    public Expression lxp;
    public Value acc;
    public Expression nxp;
    public Value[] vlr;
    public Value[] lcl;
    public Value[] env;
    public CallFrame stk;
    public CallFrame fk = top_fk;
    public SymbolicEnvironment tpl;
    static CallFrame top_fk = new CallFrame(new ThrowSchemeException(), null, false, null, null, null, null, null);
    protected static final int FRAMEPOOLMAX = 128;
    protected CallFrame frameFreeList;
    protected int frameFreeListSize;
    protected Value[] dv1;
    protected Value[] dv2;
    protected Value[] dv3;
    protected Value[] dv4;
    static /* synthetic */ Class class$sisc$interpreter$Interpreter;

    private static Expression annotatedAppEval(String string) {
        return Interpreter.annotatedAppEval(class$sisc$interpreter$Interpreter == null ? (class$sisc$interpreter$Interpreter = Interpreter.class$("sisc.interpreter.Interpreter")) : class$sisc$interpreter$Interpreter, string);
    }

    public Interpreter(ThreadContext threadContext, DynamicEnvironment dynamicEnvironment) {
        this.tctx = threadContext;
        this.dynenv = dynamicEnvironment;
        this.tpl = this.getCtx().toplevel_env;
    }

    public AppContext getCtx() {
        return this.dynenv.ctx;
    }

    public Symbol getSymbol(String string) {
        return Symbol.get(string, this.dynenv.caseSensitive);
    }

    public Expression compile(Value value) throws ContinuationException {
        return this.compile(value, this.getCtx().toplevel_env);
    }

    public Expression compile(Value value, SymbolicEnvironment symbolicEnvironment) throws ContinuationException {
        return compiler.compile(this, value, symbolicEnvironment);
    }

    public Value interpret(Expression expression) throws SchemeException {
        SymbolicEnvironment symbolicEnvironment = this.getCtx().toplevel_env;
        this.stk = this.createFrame(null, null, false, null, null, symbolicEnvironment, top_fk, null);
        this.nxp = expression;
        this.tpl = symbolicEnvironment;
        this.interpret();
        return this.acc;
    }

    protected void interpret() throws SchemeException {
        try {
            while (true) {
                try {
                    while (true) {
                        if (this.nxp == null) {
                            this.pop(this.stk);
                            continue;
                        }
                        this.nxp.eval(this);
                    }
                }
                catch (ContinuationException continuationException) {
                    this.pop(continuationException.k);
                    continue;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.nxp != null) {
                try {
                    Interpreter.error(this, null, nullPointerException.getMessage(), nullPointerException);
                }
                catch (ContinuationException continuationException) {
                    this.pop(continuationException.k);
                    this.interpret();
                }
            }
        }
        catch (SchemeRuntimeException schemeRuntimeException) {
            throw schemeRuntimeException.promote();
        }
    }

    public final void next(Expression expression) throws ContinuationException {
        this.nxp = expression;
        expression.eval(this);
    }

    public final void newVLR(int n) {
        this.newVLR(this.createValues(n));
    }

    public final void newVLR(Value[] valueArray) {
        this.vlk = false;
        this.vlr = valueArray;
    }

    public final void pop(CallFrame callFrame) {
        this.nxp = this.lxp = callFrame.nxp;
        this.vlr = callFrame.vlr;
        this.lcl = callFrame.lcl;
        this.env = callFrame.env;
        this.tpl = callFrame.tpl;
        this.fk = callFrame.fk;
        this.stk = callFrame.parent;
        this.vlk = callFrame.vlk;
        this.returnFrame(callFrame);
    }

    private final void makeSafe() {
        Value[] valueArray = this.createValues(this.vlr.length);
        System.arraycopy(this.vlr, 0, valueArray, 0, this.vlr.length);
        this.vlr = valueArray;
        this.vlk = false;
    }

    public final void setVLR(int n, Value value) {
        if (this.vlk) {
            this.makeSafe();
        }
        this.vlr[n] = value;
    }

    public final void setFailureContinuation(Expression expression) {
        this.fk = this.createFrame(expression, null, false, this.lcl, this.env, this.tpl, this.fk, this.stk);
    }

    public void error(Pair pair) throws ContinuationException {
        this.push(this.nxp == null ? this.lxp : this.nxp);
        this.acc = new Values(new Value[]{pair, new ApplyParentFrame(this.stk.capture(this))});
        throw new ContinuationException(this.fk);
    }

    public Value evalInput(InputPort inputPort) throws IOException, SchemeException {
        Value value = VOID;
        try {
            while (true) {
                value = this.eval(this.dynenv.parser.nextExpression(inputPort));
            }
        }
        catch (EOFException eOFException) {
            return value;
        }
    }

    public Value eval(String string) throws IOException, SchemeException {
        return this.evalInput(new ReaderInputPort(new BufferedReader(new StringReader(string))));
    }

    public Value eval(Value value) throws SchemeException {
        return this.eval((Procedure)this.lookup(EVAL, REPORT), new Value[]{value, (Value)((Object)this.getCtx().toplevel_env)});
    }

    public Value eval(Value value, SymbolicEnvironment symbolicEnvironment) throws SchemeException {
        return this.eval((Procedure)this.lookup(EVAL, REPORT), new Value[]{value, symbolicEnvironment.asValue()});
    }

    public Value eval(Procedure procedure, Value[] valueArray) throws SchemeException {
        this.acc = procedure;
        this.vlr = valueArray;
        return this.interpret(EVAL_APPEVAL);
    }

    public boolean loadSourceFiles(String[] stringArray) {
        boolean bl = true;
        Procedure procedure = (Procedure)this.lookup(Symbol.get("load"), Util.TOPLEVEL);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.eval(procedure, new Value[]{new SchemeString(stringArray[i])});
                continue;
            }
            catch (SchemeException schemeException) {
                block6: {
                    Pair pair = schemeException.m;
                    try {
                        this.eval((Procedure)this.lookup(Symbol.get("print-error"), Util.TOPLEVEL), new Value[]{pair, schemeException.e});
                    }
                    catch (SchemeException schemeException2) {
                        if (pair instanceof Pair) {
                            System.err.println(Util.simpleErrorToString(pair));
                            break block6;
                        }
                        System.err.println(Util.liMessage(Util.SISCB, "errorduringload") + pair);
                    }
                }
                bl = false;
            }
        }
        return bl;
    }

    public SymbolicEnvironment lookupContextEnv(Symbol symbol) {
        return this.getCtx().lookupContextEnv(symbol);
    }

    public void defineContextEnv(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this.getCtx().defineContextEnv(symbol, symbolicEnvironment);
    }

    public SymbolicEnvironment getContextEnv(Symbol symbol) {
        SymbolicEnvironment symbolicEnvironment = null;
        try {
            symbolicEnvironment = this.lookupContextEnv(symbol);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            symbolicEnvironment = new MemorySymEnv();
            this.defineContextEnv(symbol, symbolicEnvironment);
        }
        return symbolicEnvironment;
    }

    public void define(Symbol symbol, Value value, Symbol symbol2) {
        this.getContextEnv(symbol2).define(symbol, value);
    }

    public Expression lookup(Symbol symbol, Symbol symbol2) {
        try {
            return this.lookupContextEnv(symbol2).lookup(symbol);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void undefine(Symbol symbol, Symbol symbol2) {
        try {
            this.lookupContextEnv(symbol2).undefine(symbol);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private final CallFrame createFrame(Expression expression, Value[] valueArray, boolean bl, Value[] valueArray2, Value[] valueArray3, SymbolicEnvironment symbolicEnvironment, CallFrame callFrame, CallFrame callFrame2) {
        CallFrame callFrame3;
        if (this.frameFreeList == null) {
            callFrame3 = new CallFrame();
        } else {
            callFrame3 = this.frameFreeList;
            this.frameFreeList = this.frameFreeList.parent;
            --this.frameFreeListSize;
        }
        callFrame3.init(expression, valueArray, bl, valueArray2, valueArray3, symbolicEnvironment, callFrame, callFrame2);
        return callFrame3;
    }

    private final CallFrame createNearlyEmptyFrame(Expression expression, CallFrame callFrame) {
        return this.createFrame(expression, null, false, null, null, this.tpl, this.fk, callFrame);
    }

    public final void push(Expression expression) {
        this.stk = this.createFrame(expression, this.vlr, this.vlk, this.lcl, this.env, this.tpl, this.fk, this.stk);
    }

    public final void pushExpr(Expression expression) {
        this.stk = this.createNearlyEmptyFrame(expression, this.stk);
    }

    public final void returnFrame(CallFrame callFrame) {
        if (callFrame.vlk || this.frameFreeListSize >= 128) {
            return;
        }
        callFrame.clear();
        callFrame.parent = this.frameFreeList;
        this.frameFreeList = callFrame;
        ++this.frameFreeListSize;
    }

    public final Value[] createValues(int n) {
        switch (n) {
            case 0: {
                return ZV;
            }
            case 1: {
                if (this.dv1 == null) break;
                Value[] valueArray = this.dv1;
                this.dv1 = null;
                return valueArray;
            }
            case 2: {
                if (this.dv2 == null) break;
                Value[] valueArray = this.dv2;
                this.dv2 = null;
                return valueArray;
            }
            case 3: {
                if (this.dv3 == null) break;
                Value[] valueArray = this.dv3;
                this.dv3 = null;
                return valueArray;
            }
            case 4: {
                if (this.dv4 == null) break;
                Value[] valueArray = this.dv4;
                this.dv4 = null;
                return valueArray;
            }
        }
        return new Value[n];
    }

    public final void returnVLR() {
        if (this.saveVLR) {
            this.saveVLR = false;
        } else {
            if (!this.vlk) {
                this.returnValues(this.vlr);
            }
            this.vlr = null;
        }
    }

    public final void setupTailCall(Expression expression, Value value) {
        this.saveVLR = true;
        this.nxp = expression;
        if (this.vlk) {
            this.newVLR(1);
        } else if (this.vlr.length != 1) {
            this.returnValues(this.vlr);
            this.newVLR(1);
        }
        this.vlr[0] = value;
    }

    public final void setupTailCall(Expression expression, Value[] valueArray) {
        this.saveVLR = true;
        this.nxp = expression;
        if (!this.vlk) {
            this.returnValues(this.vlr);
        }
        this.vlr = valueArray;
    }

    public final void returnValues(Value[] valueArray) {
        switch (valueArray.length) {
            case 4: {
                valueArray[0] = null;
                valueArray[1] = null;
                valueArray[2] = null;
                valueArray[3] = null;
                this.dv4 = valueArray;
                break;
            }
            case 3: {
                valueArray[0] = null;
                valueArray[1] = null;
                valueArray[2] = null;
                this.dv3 = valueArray;
                break;
            }
            case 2: {
                valueArray[0] = null;
                valueArray[1] = null;
                this.dv2 = valueArray;
                break;
            }
            case 1: {
                valueArray[0] = null;
                this.dv1 = valueArray;
            }
        }
    }

    public Value[] vlrToArgs() {
        Value[] valueArray;
        if (this.vlk) {
            valueArray = this.createValues(this.vlr.length);
            System.arraycopy(this.vlr, 0, valueArray, 0, valueArray.length);
        } else {
            valueArray = this.vlr;
        }
        return valueArray;
    }

    public Value[] vlrToRestArgs(int n) {
        Value[] valueArray;
        int n2 = n - 1;
        int n3 = this.vlr.length;
        if (n3 < n || this.vlk) {
            valueArray = this.createValues(n);
            System.arraycopy(this.vlr, 0, valueArray, 0, n2);
            valueArray[n2] = Interpreter.valArrayToList(this.vlr, n2, n3 - n2);
            this.returnVLR();
        } else {
            valueArray = this.vlr;
            valueArray[n2] = Interpreter.valArrayToList(this.vlr, n2, n3 - n2);
        }
        return valueArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Interpreter.top_fk.vlk = true;
        Interpreter.top_fk.fk = top_fk;
    }

    public static class ThrowSchemeException
    extends Expression {
        public void eval(Interpreter interpreter) throws ContinuationException, SchemeRuntimeException {
            interpreter.nxp = null;
            Values values = (Values)interpreter.acc;
            throw new SchemeRuntimeException(ThrowSchemeException.pair(values.values[0]), ThrowSchemeException.proc(values.values[1]), values.values.length > 2 ? ThrowSchemeException.proc(values.values[2]) : (interpreter.fk == null ? top_fk : interpreter.fk));
        }

        public Value express() {
            return ThrowSchemeException.list(Symbol.get("TSException"));
        }

        public void serialize(Serializer serializer) throws IOException {
        }

        public void deserialize(Deserializer deserializer) throws IOException {
        }
    }
}

