/*
 * Decompiled with CFR 0.152.
 */
package sisc.io;

import java.io.IOException;
import sisc.data.Value;
import sisc.io.OutputPort;
import sisc.io.ValueWriter;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public class PortValueWriter
extends Util
implements ValueWriter,
ExpressionVisitor {
    private OutputPort port;
    private boolean display;
    private boolean vectorLengthPrefixing;
    private boolean caseSensitive;

    public PortValueWriter(OutputPort outputPort, boolean bl, boolean bl2) {
        this.port = outputPort;
        this.vectorLengthPrefixing = bl;
        this.caseSensitive = bl2;
    }

    protected void displayOrWrite(Value value, boolean bl) throws IOException {
        this.display = bl;
        this.append(value);
    }

    public void display(Value value) throws IOException {
        this.displayOrWrite(value, true);
    }

    public void write(Value value) throws IOException {
        this.displayOrWrite(value, false);
    }

    public boolean visit(ExpressionVisitee expressionVisitee) {
        return true;
    }

    public ValueWriter append(Value value) throws IOException {
        if (this.display) {
            value.display(this);
        } else {
            value.write(this);
        }
        return this;
    }

    public ValueWriter append(char c) throws IOException {
        this.port.write(c);
        return this;
    }

    public ValueWriter append(String string) throws IOException {
        this.port.write(string);
        return this;
    }

    public boolean isInlinable(Value value) {
        return true;
    }

    public boolean vectorLengthPrefixing() {
        return this.vectorLengthPrefixing;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }
}

