/*
 * Decompiled with CFR 0.152.
 */
package sisc.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sisc.data.Expression;
import sisc.data.Singleton;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.io.OutputPort;
import sisc.io.PortValueWriter;
import sisc.io.ValueWriter;
import sisc.util.ExpressionVisitee;

public class SharedValueWriter
extends PortValueWriter {
    private Map shared = new HashMap(1);
    private List visited = new LinkedList();
    private int count = 0;
    private static Integer seenMarker = new Integer(-1);
    private static Integer sharedMarker = new Integer(-2);

    public SharedValueWriter(OutputPort outputPort, boolean bl, boolean bl2) {
        super(outputPort, bl, bl2);
    }

    protected void displayOrWrite(Value value, boolean bl) throws IOException {
        this.visit(value);
        while (!this.visited.isEmpty()) {
            ((Expression)this.visited.remove(0)).visit(this);
        }
        super.displayOrWrite(value, bl);
        this.shared.clear();
        this.visited.clear();
        this.count = 0;
    }

    public boolean visit(ExpressionVisitee expressionVisitee) {
        if (expressionVisitee == null || expressionVisitee instanceof Singleton || expressionVisitee instanceof SymbolicEnvironment) {
            return true;
        }
        Object v = this.shared.get(expressionVisitee);
        if (v == null) {
            this.shared.put(expressionVisitee, seenMarker);
            this.visited.add(expressionVisitee);
        } else {
            this.shared.put(expressionVisitee, sharedMarker);
        }
        return true;
    }

    public ValueWriter append(Value value) throws IOException {
        Integer n = (Integer)this.shared.get(value);
        if (n == sharedMarker) {
            this.append('#');
            int n2 = this.count++;
            this.shared.put(value, new Integer(n2));
            this.append(Integer.toString(n2));
            this.append('=');
        } else if (n != null && n != seenMarker) {
            this.append('#');
            this.append(n.toString());
            this.append('#');
            return this;
        }
        return super.append(value);
    }

    public boolean isInlinable(Value value) {
        Object v = this.shared.get(value);
        return v == null || v == seenMarker;
    }
}

