/*
 * Decompiled with CFR 0.152.
 */
package sisc.reader;

import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import sisc.data.SchemeCharacter;
import sisc.io.InputPort;
import sisc.util.Util;

public abstract class CharUtil {
    private static final Hashtable humanReadables = new Hashtable(8);

    private static void register(char c, String string) {
        SchemeCharacter schemeCharacter = new SchemeCharacter(c);
        humanReadables.put(schemeCharacter, string);
        humanReadables.put(string, schemeCharacter);
    }

    public static SchemeCharacter namedConstToChar(String string) {
        return (SchemeCharacter)humanReadables.get(string);
    }

    public static String charToNamedConst(SchemeCharacter schemeCharacter) {
        return (String)humanReadables.get(schemeCharacter);
    }

    public static int escapedToChar(char c) {
        switch (c) {
            case '\"': {
                return c | Integer.MIN_VALUE;
            }
            case 'b': {
                return 8;
            }
            case 't': {
                return 9;
            }
            case 'n': {
                return 10;
            }
            case 'f': {
                return 12;
            }
            case 'r': {
                return 13;
            }
        }
        return c;
    }

    public static int escapeSequenceToChar(InputPort inputPort) throws IOException {
        int n = inputPort.read();
        if (n == 117) {
            char[] cArray = new char[4];
            for (int i = 0; i < cArray.length; ++i) {
                int n2 = inputPort.read();
                if (n2 == -1) {
                    throw new EOFException("End of file on hex-literal");
                }
                cArray[i] = (char)n2;
            }
            try {
                return Integer.parseInt(new String(cArray), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(Util.liMessage(Util.SISCB, "invalidcharconst"));
            }
        }
        return CharUtil.escapedToChar((char)n);
    }

    public static String charToEscaped(char c) {
        switch (c) {
            case '\b': {
                return "b";
            }
            case '\t': {
                return "t";
            }
            case '\n': {
                return "n";
            }
            case '\f': {
                return "f";
            }
            case '\r': {
                return "r";
            }
        }
        if (c < ' ' || c > '~') {
            return "u" + CharUtil.charToHex(c);
        }
        return new String(new char[]{c});
    }

    public static char octToChar(String string) {
        return (char)Integer.parseInt(string, 8);
    }

    public static char hexToChar(String string) {
        return (char)Integer.parseInt(string, 16);
    }

    public static String charToOct(char c) {
        return Util.justify(Integer.toOctalString(c), 3, '0');
    }

    public static String charToHex(char c) {
        return Util.justify(Integer.toHexString(c), 4, '0');
    }

    static {
        CharUtil.register(' ', "space");
        CharUtil.register('\b', "backspace");
        CharUtil.register('\u007f', "rubout");
        CharUtil.register('\f', "page");
        CharUtil.register('\t', "tab");
        CharUtil.register('\n', "newline");
        CharUtil.register('\r', "return");
        CharUtil.register('\u0000', "nul");
    }
}

