/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import sisc.data.Expression;
import sisc.interpreter.AppContext;
import sisc.ser.Library;
import sisc.ser.LibraryDeserializer;
import sisc.ser.SLL2Deserializer;
import sisc.ser.Seekable;
import sisc.ser.SeekableDataInputStream;
import sisc.util.Util;

public class BlockDeserializer
extends SLL2Deserializer
implements LibraryDeserializer {
    private Map classPool;
    Expression[] alreadyReadObjects;
    private int[] offsets;
    private int[] sizes;
    private long base;
    private Library baseLib;

    public BlockDeserializer(AppContext appContext, SeekableDataInputStream seekableDataInputStream, Map map, int[] nArray, int[] nArray2) throws IOException {
        super(appContext, seekableDataInputStream);
        this.base = seekableDataInputStream.getFilePointer();
        this.classPool = map;
        this.offsets = nArray;
        this.sizes = nArray2;
        this.alreadyReadObjects = new Expression[this.offsets.length];
    }

    protected void recordReadObject(int n, Expression expression) {
        if (n != -1 && this.alreadyReadObjects[n] == null) {
            this.alreadyReadObjects[n] = expression;
        }
    }

    protected Expression skipReadObject(boolean bl, int n) throws IOException {
        Expression expression = this.alreadyReadObjects[n];
        if (expression == null) {
            return this.readExpression(true, n);
        }
        for (int i = this.sizes[n]; i > 0; i -= this.datin.skipBytes(i)) {
        }
        return expression;
    }

    protected Expression fetchShared(int n) throws IOException {
        try {
            Expression expression = this.alreadyReadObjects[n];
            if (expression == null) {
                long l = ((Seekable)((Object)this.datin)).getFilePointer();
                ((Seekable)((Object)this.datin)).seek(this.base + (long)this.offsets[n]);
                expression = this.deser();
                ((Seekable)((Object)this.datin)).seek(l);
            }
            return expression;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FileNotFoundException(Util.liMessage(Util.SISCB, "invalidentrypoint", new Object[]{new Integer(n)}));
        }
    }

    public Library getLibrary() {
        return this.baseLib;
    }

    public void setLibrary(Library library) {
        this.baseLib = library;
    }

    public Class readClass() throws IOException {
        return (Class)this.classPool.get(new Integer(this.readInt()));
    }
}

