/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import sisc.data.Expression;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.ser.BerEncoding;
import sisc.ser.LibraryBinding;
import sisc.ser.Serializer;

public abstract class SerializerImpl
extends BerEncoding
implements Serializer {
    protected AppContext ctx;
    protected ObjectOutput datout;

    protected SerializerImpl(AppContext appContext, ObjectOutput objectOutput) {
        this.ctx = appContext;
        this.datout = objectOutput;
    }

    public LibraryBinding lookupLibraryBinding(Expression expression) throws IOException {
        return this.ctx.lookupBinding(expression);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        int n = bigDecimal.scale();
        byte[] byArray = bigDecimal.unscaledValue().toByteArray();
        this.writeInt(byArray.length);
        this.writeInt(n);
        this.write(byArray);
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeExpressionArray(Expression[] expressionArray) throws IOException {
        if (expressionArray == null) {
            this.writeInt(0);
        } else {
            this.writeInt(expressionArray.length);
            for (int i = 0; i < expressionArray.length; ++i) {
                this.writeExpression(expressionArray[i]);
            }
        }
    }

    public void writeSymbolicEnvironment(SymbolicEnvironment symbolicEnvironment) throws IOException {
        if (symbolicEnvironment == null) {
            this.writeExpression(null);
        } else if (symbolicEnvironment.getName() == null) {
            this.writeExpression(symbolicEnvironment.asValue());
        } else {
            this.writeExpression(symbolicEnvironment.getName());
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.datout.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.datout.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.datout.write(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.datout.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.datout.writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.datout.writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        this.datout.writeChar(n);
    }

    public void writeChars(String string) throws IOException {
        this.datout.writeChars(string);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeInt(int n) throws IOException {
        SerializerImpl.writeBer(n, this.datout);
    }

    public void writeLong(long l) throws IOException {
        SerializerImpl.writeBer(l, this.datout);
    }

    public void writeShort(int n) throws IOException {
        SerializerImpl.writeBer(n, this.datout);
    }

    public void writeUTF(String string) throws IOException {
        this.datout.writeUTF(string);
    }

    public void writeObject(Object object) throws IOException {
        this.datout.writeObject(object);
    }

    public void flush() throws IOException {
        this.datout.flush();
    }

    public void close() throws IOException {
        this.datout.close();
    }
}

