/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import sisc.data.Expression;
import sisc.interpreter.AppContext;
import sisc.ser.NestedObjectInputStream;
import sisc.ser.SLL2Deserializer;
import sisc.util.Util;

public class StreamDeserializer
extends SLL2Deserializer {
    private Map classPool;
    private Map alreadyReadObjects;

    private StreamDeserializer(AppContext appContext, NestedObjectInputStream nestedObjectInputStream) throws IOException {
        super(appContext, nestedObjectInputStream);
        nestedObjectInputStream.setDeserializerInstance(this);
        this.classPool = new HashMap();
        this.alreadyReadObjects = new HashMap();
    }

    public StreamDeserializer(AppContext appContext, InputStream inputStream) throws IOException {
        this(appContext, new NestedObjectInputStream(inputStream));
    }

    protected void recordReadObject(int n, Expression expression) {
        Integer n2;
        if (n != -1 && this.alreadyReadObjects.get(n2 = new Integer(n)) == null) {
            this.alreadyReadObjects.put(n2, expression);
        }
    }

    protected Expression skipReadObject(boolean bl, int n) throws IOException {
        Integer n2 = new Integer(n);
        Expression expression = (Expression)this.alreadyReadObjects.get(n2);
        if (expression == null) {
            return this.readExpression(bl, n);
        }
        this.readExpression(bl, n);
        return expression;
    }

    protected Expression fetchShared(int n) throws IOException {
        try {
            Expression expression = (Expression)this.alreadyReadObjects.get(new Integer(n));
            if (expression == null) {
                throw new IOException(Util.liMessage(Util.SISCB, "undefedepinstream"));
            }
            return expression;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FileNotFoundException(Util.liMessage(Util.SISCB, "invalidentrypoint", new Object[]{new Integer(n)}));
        }
    }

    public Class readClass() throws IOException {
        int n = this.readInt();
        Integer n2 = new Integer(n);
        Class<?> clazz = (Class<?>)this.classPool.get(n2);
        if (clazz == null) {
            try {
                clazz = Class.forName(this.readUTF(), true, Util.currentClassLoader());
                this.classPool.put(n2, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }
        return clazz;
    }
}

