/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.hashtable;

import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeBoolean;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.modules.hashtable.Hashtable;
import sisc.modules.hashtable.HashtableBase;
import sisc.modules.hashtable.SynchronizedHashtable;
import sisc.modules.hashtable.WeakHashtable;
import sisc.nativefun.CommonIndexedProcedure;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;

public class Primitives
extends IndexedFixableProcedure {
    public static final Symbol SHASHB = Symbol.intern((String)"sisc.modules.hashtable.Messages");
    protected static final int HT_MAKE = 0;
    protected static final int HTQ = 4;
    protected static final int HT_PUT = 5;
    protected static final int HT_GET = 6;
    protected static final int HT_REMOVE = 7;
    protected static final int HT_CLEAR = 8;
    protected static final int HT_SIZE = 9;
    protected static final int HT_TO_ALIST = 10;
    protected static final int HT_ADD_ALIST = 11;
    protected static final int HT_KEYS = 12;
    protected static final int HT_THREAD_SAFEQ = 13;
    protected static final int HT_WEAKQ = 14;
    protected static final int HT_HASH_BY_EQ = 1;
    protected static final int HT_HASH_BY_EQV = 2;
    protected static final int HT_HASH_BY_EQUAL = 3;
    protected static final int HT_HASH_BY_STRING_EQ = 17;
    protected static final int HT_HASH_BY_STRING_CI_EQ = 18;
    protected static final int HT_EQUALSFN = 15;
    protected static final int HT_HASHFN = 16;
    static /* synthetic */ Class class$sisc$modules$hashtable$Primitives$Complex;
    static /* synthetic */ Class class$sisc$modules$hashtable$Primitives$Simple;

    public static final HashtableBase shash(Value value) {
        try {
            return (HashtableBase)value;
        }
        catch (ClassCastException classCastException) {
            Primitives.typeError((Symbol)SHASHB, (String)"hashtable", (Value)value);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Index() {
            this.define("hashtable/make", 0);
            this.define("hashtable?", 4);
            this.define("hashtable/put!", class$sisc$modules$hashtable$Primitives$Complex == null ? (class$sisc$modules$hashtable$Primitives$Complex = Primitives.class$("sisc.modules.hashtable.Primitives$Complex")) : class$sisc$modules$hashtable$Primitives$Complex, 5);
            this.define("hashtable/get", 6);
            this.define("hashtable/remove!", class$sisc$modules$hashtable$Primitives$Complex == null ? (class$sisc$modules$hashtable$Primitives$Complex = Primitives.class$("sisc.modules.hashtable.Primitives$Complex")) : class$sisc$modules$hashtable$Primitives$Complex, 7);
            this.define("hashtable/clear!", class$sisc$modules$hashtable$Primitives$Complex == null ? (class$sisc$modules$hashtable$Primitives$Complex = Primitives.class$("sisc.modules.hashtable.Primitives$Complex")) : class$sisc$modules$hashtable$Primitives$Complex, 8);
            this.define("hashtable/size", 9);
            this.define("hashtable->alist", 10);
            this.define("hashtable/add-alist!", class$sisc$modules$hashtable$Primitives$Complex == null ? (class$sisc$modules$hashtable$Primitives$Complex = Primitives.class$("sisc.modules.hashtable.Primitives$Complex")) : class$sisc$modules$hashtable$Primitives$Complex, 11);
            this.define("hashtable/keys", 12);
            this.define("hashtable/thread-safe?", 13);
            this.define("hashtable/weak?", 14);
            this.define("hashtable/equivalence-function", 15);
            this.define("hashtable/hash-function", 16);
            this.define("hash-by-eq", 1);
            this.define("hash-by-eqv", 2);
            this.define("hash-by-equal", 3);
            this.define("hash-by-string=", 17);
            this.define("hash-by-string-ci=", 18);
        }

        public Value construct(Object object, int n) {
            if (object == null || object == (class$sisc$modules$hashtable$Primitives$Simple == null ? (class$sisc$modules$hashtable$Primitives$Simple = Primitives.class$("sisc.modules.hashtable.Primitives$Simple")) : class$sisc$modules$hashtable$Primitives$Simple)) {
                return new Simple(n);
            }
            return new Complex(n);
        }
    }

    public static class Complex
    extends CommonIndexedProcedure {
        public Complex() {
        }

        Complex(int n) {
            super(n);
        }

        public Value apply(Value value) throws ContinuationException {
            HashtableBase hashtableBase = Primitives.shash(value);
            switch (this.id) {
                case 8: {
                    hashtableBase.clear();
                    return VOID;
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2) throws ContinuationException {
            return this.apply(new Value[]{value, value2});
        }

        public Value apply(Value value, Value value2, Value value3) throws ContinuationException {
            return this.apply(new Value[]{value, value2, value3});
        }

        public Value apply(Value[] valueArray) throws ContinuationException {
            SchemeBoolean schemeBoolean = FALSE;
            Value value = null;
            HashtableBase hashtableBase = Primitives.shash(valueArray[0]);
            switch (this.id) {
                case 5: {
                    switch (valueArray.length) {
                        case 3: {
                            break;
                        }
                        case 4: {
                            schemeBoolean = valueArray[3];
                            break;
                        }
                        default: {
                            Complex.throwArgSizeException();
                        }
                    }
                    value = hashtableBase.put(valueArray[1], valueArray[2]);
                    break;
                }
                case 7: {
                    switch (valueArray.length) {
                        case 2: {
                            break;
                        }
                        case 3: {
                            schemeBoolean = valueArray[2];
                            break;
                        }
                        default: {
                            Complex.throwArgSizeException();
                        }
                    }
                    value = hashtableBase.remove(valueArray[1]);
                    break;
                }
                case 11: {
                    switch (valueArray.length) {
                        case 2: {
                            hashtableBase.addAList(Complex.pair((Value)valueArray[1]));
                            return hashtableBase;
                        }
                    }
                    Complex.throwArgSizeException();
                }
                default: {
                    Complex.throwArgSizeException();
                }
            }
            return value == null ? schemeBoolean : value;
        }
    }

    public static class Simple
    extends IndexedFixableProcedure {
        public Simple() {
        }

        Simple(int n) {
            super(n);
        }

        public Value apply(Value value) throws ContinuationException {
            switch (this.id) {
                case 4: {
                    return Simple.truth((boolean)(value instanceof HashtableBase));
                }
                case 1: {
                    return Quantity.valueOf((int)System.identityHashCode(value));
                }
                case 2: {
                    return Quantity.valueOf((int)value.hashCode());
                }
                case 3: {
                    return Quantity.valueOf((int)value.valueHashCode());
                }
                case 17: {
                    return Quantity.valueOf((int)Simple.string((Value)value).hashCode());
                }
                case 18: {
                    return Quantity.valueOf((int)Simple.string((Value)value).toLowerCase().hashCode());
                }
            }
            HashtableBase hashtableBase = Primitives.shash(value);
            switch (this.id) {
                case 10: {
                    return hashtableBase.toAList();
                }
                case 12: {
                    return hashtableBase.keys();
                }
                case 9: {
                    return Quantity.valueOf((int)hashtableBase.size());
                }
                case 13: {
                    return Simple.truth((boolean)(hashtableBase instanceof SynchronizedHashtable));
                }
                case 14: {
                    return Simple.truth((hashtableBase instanceof WeakHashtable || hashtableBase instanceof SynchronizedHashtable && ((SynchronizedHashtable)hashtableBase).getDelegate() instanceof WeakHashtable ? 1 : 0) != 0);
                }
                case 15: {
                    return hashtableBase.getEqualsProc();
                }
                case 16: {
                    return hashtableBase.getHashProc();
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2) throws ContinuationException {
            return this.apply(new Value[]{value, value2});
        }

        public Value apply(Value value, Value value2, Value value3) throws ContinuationException {
            return this.apply(new Value[]{value, value2, value3});
        }

        public Value apply(Value[] valueArray) throws ContinuationException {
            if (this.id == 0) {
                if (valueArray.length == 4) {
                    HashtableBase hashtableBase;
                    Procedure procedure = Simple.proc((Value)valueArray[0]);
                    Procedure procedure2 = Simple.proc((Value)valueArray[1]);
                    Hashtable hashtable = hashtableBase = Simple.truth((Value)valueArray[3]) ? new WeakHashtable(procedure, procedure2) : new Hashtable(procedure, procedure2);
                    if (Simple.truth((Value)valueArray[2])) {
                        hashtableBase = new SynchronizedHashtable(hashtableBase);
                    }
                    return hashtableBase;
                }
                Simple.throwArgSizeException();
            }
            SchemeBoolean schemeBoolean = FALSE;
            Value value = null;
            HashtableBase hashtableBase = Primitives.shash(valueArray[0]);
            switch (this.id) {
                case 6: {
                    switch (valueArray.length) {
                        case 2: {
                            break;
                        }
                        case 3: {
                            schemeBoolean = valueArray[2];
                            break;
                        }
                        default: {
                            Simple.throwArgSizeException();
                        }
                    }
                    value = hashtableBase.get(valueArray[1]);
                    break;
                }
                default: {
                    Simple.throwArgSizeException();
                }
            }
            return value == null ? schemeBoolean : value;
        }
    }
}

