/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import sisc.data.EmptyList;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.modules.io.IO;
import sisc.nativefun.CommonIndexedProcedure;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.util.Util;

public class FileManipulation
extends Util {
    protected static final int DIRECTORYQ = 1;
    protected static final int FILEQ = 2;
    protected static final int HIDDENQ = 3;
    protected static final int DIRLIST = 6;
    protected static final int LASTMODIFIED = 7;
    protected static final int SETLASTMODIFIED = 8;
    protected static final int SETREADONLY = 9;
    protected static final int LENGTH = 10;
    protected static final int GETPARENTURL = 11;
    protected static final int MAKEDIRECTORY = 12;
    protected static final int MAKEDIRECTORIES = 13;
    protected static final int RENAME = 14;
    protected static final int DELETE = 15;
    protected static final int READABLE = 16;
    protected static final int WRITEABLE = 17;
    static /* synthetic */ Class class$sisc$modules$io$FileManipulation$Complex;
    static /* synthetic */ Class class$sisc$modules$io$FileManipulation$Simple;

    public static final File fileHandle(Value value) {
        URL uRL = FileManipulation.url((Value)value);
        if (!"file".equals(uRL.getProtocol())) {
            Procedure.throwPrimException((String)FileManipulation.liMessage((Symbol)IO.IOB, (String)"notafileurl"));
        }
        String string = URLDecoder.decode(uRL.getPath());
        return new File(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Index() {
            this.define("file/hidden?", 3);
            this.define("file/is-directory?", 1);
            this.define("file/is-file?", 2);
            this.define("file/is-readable?", 16);
            this.define("file/is-writeable?", 17);
            this.define("directory/list", 6);
            this.define("file/last-modified", 7);
            this.define("file/set-last-modified!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 8);
            this.define("file/set-read-only!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 9);
            this.define("file/length", 10);
            this.define("file/rename!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 14);
            this.define("file/delete!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 15);
            this.define("_get-parent-url", 11);
            this.define("_make-directory!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 12);
            this.define("_make-directories!", class$sisc$modules$io$FileManipulation$Complex == null ? (class$sisc$modules$io$FileManipulation$Complex = FileManipulation.class$("sisc.modules.io.FileManipulation$Complex")) : class$sisc$modules$io$FileManipulation$Complex, 13);
        }

        public Value construct(Object object, int n) {
            if (object == null || object == (class$sisc$modules$io$FileManipulation$Simple == null ? (class$sisc$modules$io$FileManipulation$Simple = FileManipulation.class$("sisc.modules.io.FileManipulation$Simple")) : class$sisc$modules$io$FileManipulation$Simple)) {
                return new Simple(n);
            }
            return new Complex(n);
        }
    }

    public static class Complex
    extends CommonIndexedProcedure {
        public Complex() {
        }

        Complex(int n) {
            super(n);
        }

        public Value apply(Value value) throws ContinuationException {
            switch (this.id) {
                case 9: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).setReadOnly());
                }
                case 15: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).delete());
                }
                case 12: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).mkdir());
                }
                case 13: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).mkdirs());
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2) throws ContinuationException {
            switch (this.id) {
                case 8: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).setLastModified(Complex.num((Value)value2).longValue()));
                }
                case 14: {
                    return Complex.truth((boolean)FileManipulation.fileHandle(value).renameTo(FileManipulation.fileHandle(value2)));
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }
    }

    public static class Simple
    extends IndexedFixableProcedure {
        public Simple() {
        }

        Simple(int n) {
            super(n);
        }

        public Value apply(Value value) throws ContinuationException {
            switch (this.id) {
                case 1: {
                    return Simple.truth((boolean)FileManipulation.fileHandle(value).isDirectory());
                }
                case 2: {
                    return Simple.truth((boolean)FileManipulation.fileHandle(value).isFile());
                }
                case 3: {
                    return Simple.truth((boolean)FileManipulation.fileHandle(value).isHidden());
                }
                case 16: {
                    return Simple.truth((boolean)FileManipulation.fileHandle(value).canRead());
                }
                case 17: {
                    return Simple.truth((boolean)FileManipulation.fileHandle(value).canWrite());
                }
                case 6: {
                    EmptyList emptyList = EMPTYLIST;
                    String[] stringArray = FileManipulation.fileHandle(value).list();
                    if (stringArray == null) {
                        Simple.throwPrimException((String)Simple.liMessage((Symbol)IO.IOB, (String)"nosuchdirectory", (String)Simple.string((Value)value)));
                    }
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        emptyList = new Pair((Value)new SchemeString(stringArray[i]), (Value)emptyList);
                    }
                    return emptyList;
                }
                case 10: {
                    return Quantity.valueOf((long)FileManipulation.fileHandle(value).length());
                }
                case 7: {
                    return Quantity.valueOf((long)FileManipulation.fileHandle(value).lastModified());
                }
                case 11: {
                    try {
                        return new SchemeString(FileManipulation.fileHandle(value).getParentFile().toURL().toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                        break;
                    }
                }
                default: {
                    Simple.throwArgSizeException();
                }
            }
            return VOID;
        }
    }
}

