/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.EOFException;
import java.io.IOException;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.DeserializerPort;
import sisc.io.SerialInputPort;
import sisc.io.SerialOutputPort;
import sisc.io.SerializerPort;
import sisc.io.StreamInputPort;
import sisc.io.StreamOutputPort;
import sisc.modules.io.IO;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;
import sisc.util.Util;

public class SerialIO
extends IndexedProcedure {
    protected static Symbol BINARYB = Symbol.intern((String)"sisc.modules.io.Messages");
    protected static final int DESERIALIZE = 1;
    protected static final int SERIALIZE = 2;
    protected static final int OPENSERIALINPUTFILE = 3;
    protected static final int OPENSERIALOUTPUTFILE = 4;

    public static final SerialOutputPort soutport(Value value) {
        try {
            return (SerialOutputPort)value;
        }
        catch (ClassCastException classCastException) {
            SerialIO.typeError((Symbol)BINARYB, (String)"soutput-port", (Value)value);
            return null;
        }
    }

    public static final SerialInputPort sinport(Value value) {
        try {
            return (SerialInputPort)value;
        }
        catch (ClassCastException classCastException) {
            SerialIO.typeError((Symbol)BINARYB, (String)"sinput-port", (Value)value);
            return null;
        }
    }

    private static DeserializerPort openSerInPort(Interpreter interpreter, StreamInputPort streamInputPort) throws ContinuationException {
        try {
            return new DeserializerPort(interpreter.getCtx(), streamInputPort.getInputStream());
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)SerialIO.liMessage((Symbol)BINARYB, (String)"erroropening"), (IOException)iOException);
            return null;
        }
    }

    private static SerializerPort openSerOutPort(Interpreter interpreter, StreamOutputPort streamOutputPort, boolean bl) throws ContinuationException {
        try {
            SerializerPort serializerPort = new SerializerPort(interpreter.getCtx(), streamOutputPort.getOutputStream(), bl);
            serializerPort.flush();
            return serializerPort;
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)SerialIO.liMessage((Symbol)BINARYB, (String)"erroropening"), (IOException)iOException);
            return null;
        }
    }

    public static Value readSer(Interpreter interpreter, SerialInputPort serialInputPort) throws ContinuationException {
        try {
            return serialInputPort.readSer();
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)SerialIO.liMessage((Symbol)IO.IOB, (String)"errorreading", (String)serialInputPort.toString(), (String)iOException.getMessage()), (IOException)iOException);
            return null;
        }
    }

    public static Value writeSer(Interpreter interpreter, SerialOutputPort serialOutputPort, Value value) throws ContinuationException {
        try {
            serialOutputPort.writeSer(value);
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)SerialIO.liMessage((Symbol)IO.IOB, (String)"errorwriting", (String)serialOutputPort.toString(), (String)Util.javaExceptionToString((Exception)iOException)), (IOException)iOException);
        }
        return VOID;
    }

    public SerialIO(int n) {
        super(n);
    }

    public SerialIO() {
    }

    public Value doApply(Interpreter interpreter) throws ContinuationException {
        switch (interpreter.vlr.length) {
            case 1: {
                switch (this.id) {
                    case 3: {
                        return SerialIO.openSerInPort(interpreter, (StreamInputPort)SerialIO.inport((Value)interpreter.vlr[0]));
                    }
                    case 4: {
                        return SerialIO.openSerOutPort(interpreter, (StreamOutputPort)SerialIO.outport((Value)interpreter.vlr[0]), false);
                    }
                    case 1: {
                        return SerialIO.readSer(interpreter, SerialIO.sinport(interpreter.vlr[0]));
                    }
                }
                SerialIO.throwArgSizeException();
            }
            case 2: {
                switch (this.id) {
                    case 4: {
                        return SerialIO.openSerOutPort(interpreter, (StreamOutputPort)SerialIO.outport((Value)interpreter.vlr[0]), SerialIO.truth((Value)interpreter.vlr[1]));
                    }
                    case 2: {
                        return SerialIO.writeSer(interpreter, SerialIO.soutport(interpreter.vlr[1]), interpreter.vlr[0]);
                    }
                }
                SerialIO.throwArgSizeException();
            }
        }
        SerialIO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new SerialIO(n);
        }

        public Index() {
            this.define("serialize", 2);
            this.define("deserialize", 1);
            this.define("open-serial-input-port", 3);
            this.define("open-serial-output-port", 4);
        }
    }
}

