/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.s2j;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Vector;
import sisc.data.EmptyList;
import sisc.data.Pair;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.SchemeException;
import sisc.modules.s2j.JavaNull;
import sisc.modules.s2j.JavaObject;
import sisc.modules.s2j.JavaPrimitive;
import sisc.nativefun.IndexedFixableProcedure;

public abstract class Util
extends IndexedFixableProcedure {
    protected static final Symbol S2JB = Symbol.intern((String)"sisc.modules.s2j.Messages");
    private static HashMap primitiveTypesToNames = new HashMap();
    private static HashMap namesToPrimitiveTypes = new HashMap();
    private static HashMap primitiveTypesToClasses = new HashMap();
    private static HashMap classesToPrimitiveTypes = new HashMap();
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public Util() {
    }

    public Util(int n) {
        super(n);
    }

    public static Throwable javaException(SchemeException schemeException) {
        Object object;
        Throwable throwable = schemeException;
        Value value = null;
        for (object = schemeException.m; object != EMPTYLIST; object = (Pair)object.cdr()) {
            Pair pair;
            if (!(object.car() instanceof Pair) || (pair = (Pair)object.car()).car() != MESSAGE) continue;
            value = pair.cdr();
            break;
        }
        if (value != null && value instanceof JavaObject && (object = ((JavaObject)value).get()) instanceof Throwable) {
            throwable = (Throwable)object;
        }
        return throwable;
    }

    public static final int jtype(Value value) {
        try {
            return ((JavaObject)value).getObjType();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jobject", (Value)value);
            return 0;
        }
    }

    public static final JavaObject sjobj(Value value) {
        try {
            return (JavaObject)value;
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jobject", (Value)value);
            return null;
        }
    }

    public static final Object jobj(Value value) {
        try {
            return ((JavaObject)value).get();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jobject", (Value)value);
            return null;
        }
    }

    public static final Class jclass(Value value) {
        try {
            return (Class)((JavaObject)value).get();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jclass", (Value)value);
            return null;
        }
    }

    public static final Constructor jconstr(Value value) {
        try {
            return (Constructor)((JavaObject)value).get();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jconstructor", (Value)value);
            return null;
        }
    }

    public static final Method jmethod(Value value) {
        try {
            return (Method)((JavaObject)value).get();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jmethod", (Value)value);
            return null;
        }
    }

    public static final Field jfield(Value value) {
        try {
            return (Field)((JavaObject)value).get();
        }
        catch (ClassCastException classCastException) {
            Util.typeError((Symbol)S2JB, (String)"jfield", (Value)value);
            return null;
        }
    }

    public static final JavaObject makeJObj(Object object) {
        if (object == null) {
            throw new RuntimeException(Util.liMessage((Symbol)S2JB, (String)"unexpectednull"));
        }
        return new JavaObject(object);
    }

    public static final JavaObject makeJObj(Object object, Class clazz) {
        if (object == null) {
            return new JavaNull(clazz);
        }
        Class clazz2 = Util.fixClass(clazz);
        return clazz2 == clazz ? new JavaObject(object) : new JavaPrimitive(clazz, object);
    }

    public static final Value objArrayToVec(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        JavaObject[] javaObjectArray = new JavaObject[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            javaObjectArray[i] = Util.makeJObj(objectArray[i], clazz);
        }
        return new SchemeVector((Value[])javaObjectArray);
    }

    public static final Pair objectsToList(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        EmptyList emptyList = EMPTYLIST;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            emptyList = new Pair((Value)Util.makeJObj(objectArray[i], clazz), (Value)emptyList);
        }
        return emptyList;
    }

    public static Vector pairToObjVect(Pair pair) {
        Vector<Object> vector = new Vector<Object>();
        while (pair != EMPTYLIST) {
            vector.addElement(Util.jobj(pair.car()));
            pair = (Pair)pair.cdr();
        }
        return vector;
    }

    public static final Object[] pairToObjects(Pair pair) {
        Vector vector = Util.pairToObjVect(pair);
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Class makeArrayClass(Class clazz, int n) {
        return Array.newInstance(clazz, new int[n]).getClass();
    }

    public static Class resolvePrimitiveType(String string) {
        return (Class)namesToPrimitiveTypes.get(string);
    }

    public static String namePrimitiveType(Class clazz) {
        return (String)primitiveTypesToNames.get(clazz);
    }

    public static Class resolveType(String string, ClassLoader classLoader) throws IOException {
        int n = string.indexOf(91);
        if (n != -1) {
            Class clazz = Util.resolveType(string.substring(0, n), classLoader);
            return clazz == null ? null : Util.makeArrayClass(clazz, (string.length() - n) / 2);
        }
        Class clazz = Util.resolvePrimitiveType(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
    }

    public static Class resolveType(String string) throws IOException {
        return Util.resolveType(string, Util.currentClassLoader());
    }

    public static String nameType(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            StringBuffer stringBuffer = new StringBuffer("[]");
            while (clazz2.isArray()) {
                stringBuffer.append("[]");
                clazz2 = clazz2.getComponentType();
            }
            return Util.nameType(clazz2) + stringBuffer;
        }
        String string = Util.namePrimitiveType(clazz);
        return string == null ? clazz.getName() : string;
    }

    public static Class fixClass(Class clazz) {
        Class clazz2 = (Class)primitiveTypesToClasses.get(clazz);
        return clazz2 == null ? clazz : clazz2;
    }

    public static String mangleFieldName(String string) {
        char c;
        int n;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (!Character.isJavaIdentifierStart(c)) continue;
            stringBuffer.append(c);
            break;
        }
        ++n;
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            } else {
                while (n < n2) {
                    c = string.charAt(n);
                    if (Character.isJavaIdentifierPart(c)) {
                        stringBuffer.append(Character.toUpperCase(c));
                        break;
                    }
                    ++n;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String mangleMethodName(String string) {
        int n = string.length();
        if (string.endsWith("!")) {
            string = string.substring(0, n - 1);
            --n;
        }
        if (string.endsWith("?")) {
            string = "is-" + string.substring(0, n - 1);
            n += 2;
        }
        return Util.mangleFieldName(string);
    }

    public static String mangleClassName(String string) {
        String string2;
        int n;
        int n2 = string.length();
        if (string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, n2 - 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
            stringBuffer.append("[]");
        }
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            stringBuffer.append("[]");
        }
        int n3 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(n2);
        while ((n = string.indexOf(46, n3)) != -1) {
            stringBuffer2.append(Util.mangleFieldName(string.substring(n3, n))).append('.');
            n3 = n + 1;
        }
        while ((n = string.indexOf(47, n3)) != -1) {
            string2 = Util.mangleFieldName(string.substring(n3, n));
            stringBuffer2.append(Character.toUpperCase(string2.charAt(0))).append(string2.substring(1)).append('$');
            n3 = n + 1;
        }
        string2 = Util.mangleFieldName(string.substring(n3, string.length()));
        stringBuffer2.append(Character.toUpperCase(string2.charAt(0))).append(string2.substring(1));
        return stringBuffer2.append(stringBuffer.toString()).toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object[] objectArray = new Object[]{"void", Void.TYPE, class$java$lang$Void == null ? (class$java$lang$Void = Util.class$("java.lang.Void")) : class$java$lang$Void, "boolean", Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Util.class$("java.lang.Boolean")) : class$java$lang$Boolean, "char", Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Util.class$("java.lang.Character")) : class$java$lang$Character, "byte", Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Util.class$("java.lang.Byte")) : class$java$lang$Byte, "short", Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Util.class$("java.lang.Short")) : class$java$lang$Short, "int", Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Util.class$("java.lang.Integer")) : class$java$lang$Integer, "long", Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Util.class$("java.lang.Long")) : class$java$lang$Long, "float", Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Util.class$("java.lang.Float")) : class$java$lang$Float, "double", Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Util.class$("java.lang.Double")) : class$java$lang$Double};
        for (int i = 0; i < objectArray.length; i += 3) {
            namesToPrimitiveTypes.put(objectArray[i], objectArray[i + 1]);
            primitiveTypesToNames.put(objectArray[i + 1], objectArray[i]);
            primitiveTypesToClasses.put(objectArray[i + 1], objectArray[i + 2]);
            classesToPrimitiveTypes.put(objectArray[i + 2], objectArray[i + 1]);
        }
    }
}

