/*
 * Decompiled with CFR 0.152.
 */
package siscweb.contcentric;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import javax.servlet.http.HttpSession;
import sisc.data.Procedure;
import siscweb.contcentric.ContinuationStore;
import siscweb.contcentric.ContinuationTable;

public class FileContinuationStore
implements ContinuationStore {
    private static final File baseDirectory = new File("/tmp");
    private static final long ttl = 1200000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(HttpSession session, String groupId, String continuationId, Procedure procedure, long ttl) {
        File sessionDirectory = new File(baseDirectory, session.getId());
        if (!sessionDirectory.exists()) {
            sessionDirectory.mkdir();
        }
        ObjectOutputStream oos = null;
        try {
            try {
                File continuationFile = new File(sessionDirectory, continuationId);
                oos = new ObjectOutputStream(new FileOutputStream(continuationFile));
                oos.writeObject(procedure);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Object var11_10 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (oos == null) throw throwable;
                oos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (oos != null) {
            oos.close();
        }
        ContinuationTable.getInstance(session).store(session, groupId, continuationId, procedure, ttl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Procedure fetch(HttpSession session, String continuationId) {
        Procedure procedure;
        File sessionDirectory = new File(baseDirectory, session.getId());
        if (!sessionDirectory.exists()) {
            return null;
        }
        File continuationFile = new File(sessionDirectory, continuationId);
        if (!continuationFile.exists()) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            try {
                continuationFile.setLastModified(new Date().getTime());
                ois = new ObjectInputStream(new FileInputStream(continuationFile));
                procedure = (Procedure)ois.readObject();
                Object var8_9 = null;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (ois == null) throw throwable;
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        try {}
        catch (IOException ioe) {
            return null;
        }
        if (ois == null) return procedure;
        ois.close();
        return procedure;
    }

    public void clear(HttpSession session) {
        File sessionDirectory = new File(baseDirectory, session.getId());
        if (sessionDirectory.exists()) {
            FileContinuationStore.deleteFile(sessionDirectory);
        }
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileContinuationStore.deleteFile(children[i]);
            }
        }
        return file.delete();
    }

    public int purgeExpired() {
        long now = new Date().getTime();
        int n = 0;
        File[] sessionFiles = baseDirectory.listFiles();
        for (int i = 0; i < sessionFiles.length; ++i) {
            if (!sessionFiles[i].exists()) continue;
            File[] continuationFiles = sessionFiles[i].listFiles();
            for (int j = 0; j < continuationFiles.length; ++j) {
                if (continuationFiles[i].lastModified() + 1200000L <= now || !continuationFiles[i].delete()) continue;
                ++n;
            }
        }
        return n;
    }
}

