/*
 * Decompiled with CFR 0.152.
 */
package siscweb.contcentric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import sisc.data.Procedure;
import siscweb.contcentric.ContinuationStore;
import siscweb.contcentric.ContinuationTable;

public class SessionContinuationStore
implements ContinuationStore {
    private final HashMap continuationTables = new HashMap();

    public void store(HttpSession session, String groupId, String continuationId, Procedure procedure, long ttl) {
        ContinuationTable.getInstance(session).store(session, groupId, continuationId, procedure, ttl);
    }

    public Procedure fetch(HttpSession session, String continuationId) {
        ContinuationTable table = ContinuationTable.getInstance(session);
        if (table == null) {
            return null;
        }
        return table.fetch(session, continuationId);
    }

    public void clear(HttpSession session) {
        ContinuationTable.getInstance(session).clear(session);
    }

    public int purgeExpired() {
        int n = 0;
        Iterator i = new ArrayList(this.continuationTables.keySet()).iterator();
        while (i.hasNext()) {
            String sid = (String)i.next();
            ContinuationTable ct = (ContinuationTable)this.continuationTables.get(sid);
            if (ct == null) continue;
            n += ct.purgeExpired();
        }
        return n;
    }

    public HashMap getContinuationTables() {
        return this.continuationTables;
    }

    public void register(ContinuationTable ct) {
        this.continuationTables.put(ct.getId(), ct);
    }

    public void unregister(ContinuationTable ct) {
        this.continuationTables.remove(ct.getId());
    }
}

