/*
 * Decompiled with CFR 0.152.
 */
package siscweb.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import sisc.REPL;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;

public class REPLThread
extends Thread {
    private String host;
    private int port;
    protected ServerSocket socket;

    public REPLThread(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void run() {
        try {
            InetAddress addr = InetAddress.getByName(this.host);
            this.socket = new ServerSocket(this.port, 50, addr);
            REPL.listen((AppContext)Context.getDefaultAppContext(), (ServerSocket)this.socket);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("REPL could not resolve " + this.host, e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void terminate() {
        try {
            this.interrupt();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                if (this.socket == null) throw throwable;
                this.socket.close();
                this.socket = null;
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("REPL could not close socket at " + this.host + ":" + this.port, e);
            }
        }
        try {
            if (this.socket == null) return;
            this.socket.close();
            this.socket = null;
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("REPL could not close socket at " + this.host + ":" + this.port, e);
        }
    }
}

