/*
 * Decompiled with CFR 0.152.
 */
package siscweb.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import sisc.data.Procedure;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeCaller;
import sisc.interpreter.SchemeException;
import sisc.modules.s2j.JavaObject;
import sisc.modules.s2j.Util;

public class SISCInitializer
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        String contextName = context.getServletContextName();
        try {
            AppContext ctx = new AppContext();
            Context.setDefaultAppContext((AppContext)ctx);
            ctx.addDefaultHeap();
            Interpreter r = Context.enter((AppContext)ctx);
            r.define(Symbol.get((String)"*SISCWEB.SERVLET-CONTEXT*"), (Value)new JavaObject((Object)context), sisc.util.Util.TOPLEVEL);
            this.evalInitParameter(context, "on-init-sexp");
        }
        catch (IOException e) {
            throw new RuntimeException(contextName + ": I/O error while loading SISC heap. (Perhaps you forgot to include sisc-heap.jar?)", e);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        this.evalInitParameter(context, "on-destroy-sexp");
    }

    private void evalInitParameter(final ServletContext context, final String name) throws RuntimeException {
        final String contextName = context.getServletContextName();
        String tsexp = context.getInitParameter("siscweb." + name);
        if (tsexp == null) {
            tsexp = context.getInitParameter(name);
        }
        final String sexp = tsexp;
        try {
            if (sexp != null) {
                Context.execute((SchemeCaller)new SchemeCaller(){

                    public Object execute(Interpreter r) throws SchemeException {
                        try {
                            Procedure currentDirectory = (Procedure)r.lookup(Symbol.get((String)"current-directory"), sisc.util.Util.TOPLEVEL);
                            r.eval(currentDirectory, new Value[]{new SchemeString(context.getRealPath("/"))});
                            return r.eval(sexp);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(contextName + " : error reading context parameter " + name + ".", e);
                        }
                    }
                });
            }
        }
        catch (SchemeException e) {
            System.err.println(contextName + " : error evaluating " + name + " parameter. Scheme stack trace follows:");
            try {
                Context.execute((SchemeCaller)new SchemeCaller(){

                    public Object execute(Interpreter r) throws SchemeException {
                        Procedure printError = (Procedure)r.lookup(Symbol.get((String)"print-error"), sisc.util.Util.TOPLEVEL);
                        return r.eval(printError, new Value[]{e.m, e.e});
                    }
                });
                throw new RuntimeException(contextName + " : error evaluating parameter " + name + ".", Util.javaException((SchemeException)e));
            }
            catch (SchemeException f) {
                throw new RuntimeException(contextName + " : error printing scheme stack trace during evaluation of context parameter " + name + ".", Util.javaException((SchemeException)f));
            }
        }
    }
}

