/*
 * Decompiled with CFR 0.152.
 */
package sisc.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import sisc.compiler.CompilerConstants;
import sisc.compiler.Syntax;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.MemorySymEnv;
import sisc.env.SymbolicEnvironment;
import sisc.exprs.AnnotatedExpr;
import sisc.exprs.AppEval;
import sisc.exprs.AppExp;
import sisc.exprs.DefineEval;
import sisc.exprs.EvalExp;
import sisc.exprs.FillRibExp;
import sisc.exprs.FreeReferenceExp;
import sisc.exprs.FreeSetEval;
import sisc.exprs.IfEval;
import sisc.exprs.LambdaExp;
import sisc.exprs.LetrecEval;
import sisc.exprs.LetrecExp;
import sisc.exprs.LexicalReferenceExp;
import sisc.exprs.LocalReferenceExp;
import sisc.exprs.SetboxEval;
import sisc.exprs.UnboxExp;
import sisc.exprs.fp.FixedAppExp_0;
import sisc.exprs.fp.FixedAppExp_1;
import sisc.exprs.fp.FixedAppExp_2;
import sisc.exprs.fp.FixedAppExp_3;
import sisc.exprs.fp.OptimisticExpression;
import sisc.exprs.fp.OptimisticHost;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.StreamInputPort;
import sisc.modules.Primitives;
import sisc.nativefun.FixableProcedure;
import sisc.reader.Lexer;
import sisc.reader.Parser;
import sisc.util.FreeReference;
import sisc.util.Util;

public class Compiler
extends CompilerConstants {
    public static void addSpecialForms(SymbolicEnvironment symbolicEnvironment) {
        Iterator iterator = SYNTACTIC_TOKENS.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string = (String)k;
            Compiler.extendenv(symbolicEnvironment, string, (Syntax)SYNTACTIC_TOKENS.get(string));
        }
    }

    protected Expression compile(Interpreter interpreter, Expression expression, Pair pair, ReferenceFactory referenceFactory, int n, SymbolicEnvironment symbolicEnvironment, Pair pair2) throws ContinuationException {
        if (expression == EMPTYLIST) {
            return EMPTYLIST;
        }
        if (expression instanceof Pair) {
            Pair pair3 = (Pair)expression;
            return this.compileApp(interpreter, pair3, pair, referenceFactory, n, symbolicEnvironment, pair2);
        }
        if (expression instanceof Symbol) {
            Symbol symbol = (Symbol)expression;
            Expression expression2 = referenceFactory.createReference(symbol, pair, symbolicEnvironment);
            if (pair2 != null) {
                Compiler.setAnnotations(expression2, pair2);
            }
            return expression2;
        }
        return expression;
    }

    public Expression compile(Interpreter interpreter, Expression expression, SymbolicEnvironment symbolicEnvironment) throws ContinuationException {
        Expression expression2 = this.compile(interpreter, expression, EMPTYLIST, new ReferenceFactory(), 1, symbolicEnvironment, null);
        return expression2;
    }

    public static final int getExpType(SymbolicEnvironment symbolicEnvironment, Value value) {
        Value value2;
        if (value instanceof Syntax) {
            return ((Syntax)value).synid;
        }
        if (value instanceof Symbol && (value2 = symbolicEnvironment.lookup((Symbol)value)) != null && value2 instanceof Syntax) {
            return ((Syntax)value2).synid;
        }
        return 1;
    }

    static void addAnnotations(Expression expression, Map map) {
        if (map != null) {
            if (expression.annotations == null) {
                expression.annotations = map;
            } else {
                expression.annotations.putAll(map);
            }
        }
    }

    static void setAnnotations(Expression expression, Pair pair) {
        while (pair != EMPTYLIST) {
            Pair pair2 = (Pair)pair.car();
            expression.setAnnotation(Compiler.symbol(pair2.car()), pair2.cdr());
            pair = (Pair)pair.cdr();
        }
    }

    static void propagateNameAnnotation(Expression expression, Expression expression2) {
        if (expression instanceof FreeReferenceExp) {
            expression2.setAnnotation(PROCNAME, ((FreeReferenceExp)expression).getSym());
        }
    }

    static boolean isImmediate(Expression expression) {
        return expression instanceof Immediate || expression instanceof AnnotatedExpr && ((AnnotatedExpr)expression).expr instanceof Immediate;
    }

    Expression makeEvalExp(Expression expression, Expression expression2) {
        EvalExp evalExp = new EvalExp(expression, expression2, Compiler.isImmediate(expression));
        evalExp.setHosts();
        return evalExp;
    }

    protected int[][] resolveCopies(ReferenceFactory referenceFactory, Symbol[] symbolArray) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(5);
        for (int i = symbolArray.length - 1; i >= 0; --i) {
            Ref ref = referenceFactory.fetchRefType(symbolArray[i]);
            if (ref == null) continue;
            if (ref.lcl) {
                arrayList.add(new Integer(ref.idx));
                continue;
            }
            arrayList2.add(new Integer(ref.idx));
        }
        int[][] nArrayArray = new int[][]{new int[arrayList.size()], new int[arrayList2.size()]};
        for (n = 0; n < arrayList.size(); ++n) {
            nArrayArray[0][n] = (Integer)arrayList.get(n);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            nArrayArray[1][n] = (Integer)arrayList2.get(n);
        }
        return nArrayArray;
    }

    public int[] findBoxes(Symbol[] symbolArray, Pair pair) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        for (int i = 0; i < symbolArray.length; ++i) {
            if (Compiler.assq(symbolArray[i], pair) == FALSE) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public Expression compileApp(Interpreter interpreter, Pair pair, Pair pair2, ReferenceFactory referenceFactory, int n, SymbolicEnvironment symbolicEnvironment, Pair pair3) throws ContinuationException {
        Expression expression;
        Value value = pair.car();
        int n2 = Compiler.getExpType(symbolicEnvironment, value);
        pair = (Pair)pair.cdr();
        switch (n2) {
            case 5: {
                expression = pair.car();
                break;
            }
            case 0: {
                pair = (Pair)pair.cdr();
                pair2 = Compiler.append((Pair)pair.car(), pair2);
                pair = (Pair)pair.cdr();
                pair = (Pair)pair.cdr();
                expression = this.compile(interpreter, pair.car(), pair2, referenceFactory, n, symbolicEnvironment, null);
                break;
            }
            case 2: {
                boolean bl = false;
                pair = (Pair)pair.cdr();
                Symbol[] symbolArray = null;
                Value value2 = pair.car();
                if (value2 instanceof Pair && value2 != EMPTYLIST) {
                    symbolArray = Compiler.argsToSymbols((Pair)value2);
                    while ((value2 = ((Pair)value2).cdr()) != EMPTYLIST && value2 instanceof Pair) {
                    }
                    bl = value2 instanceof Symbol;
                } else if (pair.car() instanceof Symbol) {
                    symbolArray = new Symbol[]{(Symbol)pair.car()};
                    bl = true;
                } else {
                    symbolArray = new Symbol[]{};
                }
                pair = (Pair)pair.cdr();
                Symbol[] symbolArray2 = Compiler.argsToSymbols((Pair)pair.car());
                pair = (Pair)pair.cdr();
                ReferenceFactory referenceFactory2 = new ReferenceFactory(symbolArray, symbolArray2);
                Expression expression2 = this.compile(interpreter, pair.car(), pair2, referenceFactory2, 1, symbolicEnvironment, null);
                int[][] nArray = this.resolveCopies(referenceFactory, symbolArray2);
                int[] nArray2 = this.findBoxes(symbolArray, pair2);
                expression = new LambdaExp(symbolArray.length, expression2, bl, nArray[0], nArray[1], nArray2.length == 0 ? null : nArray2);
                break;
            }
            case 9: {
                Object[] objectArray;
                pair = (Pair)pair.cdr();
                Vector<Value> vector = new Vector<Value>();
                Vector<Value> vector2 = new Vector<Value>();
                for (Pair pair4 = (Pair)pair.car(); pair4 != EMPTYLIST; pair4 = (Pair)pair4.cdr()) {
                    objectArray = (Object[])pair4.car();
                    vector.add(objectArray.car());
                    vector2.add(((Pair)objectArray.cdr()).car());
                }
                objectArray = new Symbol[vector.size()];
                Object[] objectArray2 = new Expression[vector2.size()];
                vector.copyInto(objectArray);
                vector2.copyInto(objectArray2);
                pair = (Pair)pair.cdr();
                Symbol[] symbolArray = Compiler.argsToSymbols((Pair)pair.car());
                pair = (Pair)pair.cdr();
                expression = this.compileLetrec(interpreter, (Symbol[])objectArray, symbolArray, (Expression[])objectArray2, pair.car(), pair2, referenceFactory, symbolicEnvironment, n);
                break;
            }
            case 3: {
                Expression expression3 = this.compile(interpreter, pair.car(), pair2, referenceFactory, 0, symbolicEnvironment, null);
                pair = (Pair)pair.cdr();
                Expression expression4 = this.compile(interpreter, pair.car(), pair2, referenceFactory, 0, symbolicEnvironment, null);
                pair = (Pair)pair.cdr();
                Expression expression5 = this.compile(interpreter, pair.car(), pair2, referenceFactory, 0, symbolicEnvironment, null);
                expression = new IfEval(expression4, expression5);
                ((OptimisticHost)((Object)expression)).setHosts();
                expression.annotations = expression3.annotations;
                expression = this.makeEvalExp(expression3, expression);
                break;
            }
            case 4: {
                expression = this.compileBegin(interpreter, Compiler.pairToExpressions(pair), n, pair2, referenceFactory, symbolicEnvironment);
                break;
            }
            case 6: {
                Symbol symbol = (Symbol)pair.car();
                Expression expression6 = this.compile(interpreter, symbol, pair2, referenceFactory, 0, symbolicEnvironment, null);
                pair = (Pair)pair.cdr();
                Expression expression7 = this.compile(interpreter, pair.car(), pair2, referenceFactory, 0, symbolicEnvironment, null);
                expression = expression6 instanceof FreeReferenceExp ? new FreeSetEval(symbol, symbolicEnvironment) : new SetboxEval(((UnboxExp)expression6).ref);
                expression.annotations = expression7.annotations;
                expression = this.makeEvalExp(expression7, expression);
                break;
            }
            case 7: {
                Symbol symbol = (Symbol)pair.car();
                pair = (Pair)pair.cdr();
                Expression expression8 = this.compile(interpreter, pair.car(), pair2, referenceFactory, 0, symbolicEnvironment, null);
                expression = new DefineEval(symbol, symbolicEnvironment);
                Compiler.addAnnotations(expression, expression8.annotations);
                expression = this.makeEvalExp(expression8, expression);
                break;
            }
            case 8: {
                Value value3 = pair.car();
                pair = (Pair)pair.cdr();
                Pair pair5 = null;
                pair5 = pair.car() instanceof Pair ? Compiler.pair(pair.car()) : Compiler.list(new Pair(OTHER, pair.car()));
                expression = this.compile(interpreter, value3, pair2, referenceFactory, n, symbolicEnvironment, pair5);
                pair3 = null;
                break;
            }
            case -1: 
            case 1: {
                Expression[] expressionArray = Compiler.pairToExpressions(pair);
                this.compileExpressions(interpreter, expressionArray, pair2, referenceFactory, 0, symbolicEnvironment);
                Expression expression9 = this.compile(interpreter, value, pair2, referenceFactory, 0, symbolicEnvironment, pair3);
                expression = Compiler.application(interpreter, expression9, expressionArray, n, pair3, symbolicEnvironment);
                break;
            }
            default: {
                Compiler.error(interpreter, "Unsupported syntactic type [" + n2 + "].  Should never happen!");
                expression = null;
            }
        }
        if (pair3 != null) {
            Compiler.setAnnotations(expression, pair3);
        }
        return expression;
    }

    public static final Expression makeFillRib(Interpreter interpreter, Expression expression, Expression expression2, int n, Expression expression3, boolean bl) {
        expression3 = new FillRibExp(expression, n, expression3, bl);
        Compiler.addAnnotations(expression3, expression2.annotations);
        if (interpreter.dynenv.emitDebuggingSymbols && expression2 instanceof AppExp) {
            AppExp appExp = (AppExp)expression2;
            Compiler.propagateNameAnnotation(appExp.exp, expression3);
        }
        return expression3;
    }

    public Expression compileLetrec(Interpreter interpreter, Symbol[] symbolArray, Symbol[] symbolArray2, Expression[] expressionArray, Expression expression, Pair pair, ReferenceFactory referenceFactory, SymbolicEnvironment symbolicEnvironment, int n) throws ContinuationException {
        ReferenceFactory referenceFactory2 = new ReferenceFactory(symbolArray, symbolArray2);
        this.compileExpressions(interpreter, expressionArray, pair, referenceFactory2, 0, symbolicEnvironment);
        boolean bl = true;
        Expression expression2 = new LetrecEval(this.compile(interpreter, expression, pair, referenceFactory2, 0, symbolicEnvironment, null));
        ((OptimisticHost)((Object)expression2)).setHosts();
        if (interpreter.dynenv.emitDebuggingSymbols) {
            expression2.setAnnotation(PROCNAME, _LETREC);
        }
        Expression expression3 = VOID;
        for (int i = 0; i < expressionArray.length; ++i) {
            if (Compiler.isImmediate(expressionArray[i])) continue;
            expression2 = Compiler.makeFillRib(interpreter, expression3, expressionArray[i], i, expression2, bl);
            expression3 = expressionArray[i];
            expressionArray[i] = null;
            bl = false;
        }
        int[][] nArray = this.resolveCopies(referenceFactory, symbolArray2);
        LetrecExp letrecExp = new LetrecExp(expression3, expressionArray, expression2, nArray[0], nArray[1], bl);
        letrecExp.setHosts();
        return letrecExp;
    }

    public static final Expression application(Interpreter interpreter, Expression expression, Expression[] expressionArray, int n, Pair pair, SymbolicEnvironment symbolicEnvironment) throws ContinuationException {
        FreeReference freeReference;
        Symbol symbol;
        Value value;
        if (expression instanceof Value && !(expression instanceof Procedure) && !(expression instanceof AnnotatedExpr)) {
            System.err.println(Compiler.warn("nonprocappdetected", ((Value)expression).synopsis()));
        }
        Expression expression2 = new AppEval((n & 1) != 0);
        if (pair != null) {
            Compiler.setAnnotations(expression2, pair);
        }
        if (interpreter.dynenv.emitDebuggingSymbols) {
            Compiler.propagateNameAnnotation(expression, expression2);
        }
        Expression expression3 = expression;
        boolean bl = Compiler.isImmediate(expression);
        Compiler.addAnnotations(expression2, expression3.annotations);
        for (int i = 0; i < expressionArray.length; ++i) {
            if (Compiler.isImmediate(expressionArray[i])) continue;
            expression2 = Compiler.makeFillRib(interpreter, expression3, expressionArray[i], i, expression2, bl);
            expression3 = expressionArray[i];
            expressionArray[i] = null;
            bl = false;
        }
        if (bl && expression instanceof FreeReferenceExp && (n & 1) == 0 && (value = symbolicEnvironment.lookup(symbol = (freeReference = ((FreeReferenceExp)expression).getReference()).getName())) instanceof FixableProcedure) {
            FixedAppExp_0 fixedAppExp_0 = null;
            switch (expressionArray.length) {
                case 0: {
                    fixedAppExp_0 = new FixedAppExp_0(freeReference);
                    break;
                }
                case 1: {
                    fixedAppExp_0 = new FixedAppExp_1((Immediate)((Object)expressionArray[0]), freeReference);
                    break;
                }
                case 2: {
                    fixedAppExp_0 = new FixedAppExp_2((Immediate)((Object)expressionArray[0]), (Immediate)((Object)expressionArray[1]), freeReference);
                    break;
                }
                case 3: {
                    fixedAppExp_0 = new FixedAppExp_3((Immediate)((Object)expressionArray[0]), (Immediate)((Object)expressionArray[1]), (Immediate)((Object)expressionArray[2]), freeReference);
                }
            }
            if (fixedAppExp_0 != null) {
                if (pair != null) {
                    Compiler.setAnnotations(fixedAppExp_0, pair);
                }
                if (interpreter.dynenv.emitDebuggingSymbols) {
                    Compiler.propagateNameAnnotation(expression, fixedAppExp_0);
                }
                Compiler.addAnnotations(fixedAppExp_0, expression3.annotations);
                if (fixedAppExp_0 instanceof OptimisticHost) {
                    ((OptimisticHost)((Object)fixedAppExp_0)).setHosts();
                }
                if (!interpreter.dynenv.hedgedInlining) {
                    ((OptimisticExpression)fixedAppExp_0).dropSafe();
                }
                return fixedAppExp_0;
            }
        }
        AppExp appExp = new AppExp(expression3, expressionArray, expression2, bl);
        if (pair != null) {
            Compiler.setAnnotations(appExp, pair);
        }
        appExp.setHosts();
        return appExp;
    }

    void compileExpressions(Interpreter interpreter, Expression[] expressionArray, Pair pair, ReferenceFactory referenceFactory, int n, SymbolicEnvironment symbolicEnvironment) throws ContinuationException {
        for (int i = expressionArray.length - 1; i >= 0; --i) {
            expressionArray[i] = this.compile(interpreter, expressionArray[i], pair, referenceFactory, n, symbolicEnvironment, null);
        }
    }

    Expression compileBegin(Interpreter interpreter, Expression[] expressionArray, int n, Pair pair, ReferenceFactory referenceFactory, SymbolicEnvironment symbolicEnvironment) throws ContinuationException {
        Expression expression;
        Expression expression2 = expression = this.compile(interpreter, expressionArray[expressionArray.length - 1], pair, referenceFactory, expressionArray.length > 1 ? 1 : 0, symbolicEnvironment, null);
        for (int i = expressionArray.length - 2; i >= 0; --i) {
            Expression expression3 = this.compile(interpreter, expressionArray[i], pair, referenceFactory, 0, symbolicEnvironment, null);
            Compiler.addAnnotations(expression2, expression3.annotations);
            expression2 = this.makeEvalExp(expression3, expression2);
        }
        return expression2;
    }

    public static void main(String[] stringArray) throws Exception {
        Interpreter interpreter = Context.enter();
        Parser parser = new Parser(new Lexer());
        StreamInputPort streamInputPort = new StreamInputPort(System.in);
        MemorySymEnv memorySymEnv = new MemorySymEnv();
        Compiler.addSpecialForms(memorySymEnv);
        new Primitives.Index().bindAll(interpreter, memorySymEnv);
        Compiler compiler = new Compiler();
        Expression expression = compiler.compile(interpreter, parser.nextExpression(streamInputPort), memorySymEnv);
        System.out.println(expression.express());
        System.err.println(interpreter.interpret(expression));
    }

    static class ReferenceFactory {
        Symbol[] locals;
        Symbol[] lexicals;

        public ReferenceFactory() {
        }

        public ReferenceFactory(Symbol[] symbolArray, Symbol[] symbolArray2) {
            this.locals = symbolArray;
            this.lexicals = symbolArray2;
        }

        public Ref fetchRefType(Symbol symbol) {
            int n;
            if (this.locals != null) {
                for (n = this.locals.length - 1; n >= 0; --n) {
                    if (this.locals[n] != symbol) continue;
                    return new Ref(true, n);
                }
            }
            if (this.lexicals != null) {
                for (n = this.lexicals.length - 1; n >= 0; --n) {
                    if (this.lexicals[n] != symbol) continue;
                    return new Ref(false, n);
                }
            }
            return null;
        }

        public Expression createReference(Symbol symbol, Pair pair, SymbolicEnvironment symbolicEnvironment) {
            Ref ref = this.fetchRefType(symbol);
            if (ref == null) {
                return new FreeReferenceExp(symbol, symbolicEnvironment);
            }
            Expression expression = ref.lcl ? new LocalReferenceExp(ref.idx) : new LexicalReferenceExp(ref.idx);
            return Util.assq(symbol, pair) != Util.FALSE ? new UnboxExp((Immediate)((Object)expression)) : (Expression)expression;
        }
    }

    static class Ref {
        int idx;
        boolean lcl;

        public Ref(boolean bl, int n) {
            this.lcl = bl;
            this.idx = n;
        }
    }
}

