/*
 * Decompiled with CFR 0.152.
 */
package sisc.compiler;

import java.util.HashMap;
import java.util.Map;
import sisc.compiler.Syntax;
import sisc.data.Symbol;
import sisc.env.SymbolicEnvironment;
import sisc.util.Util;

public abstract class CompilerConstants
extends Util {
    public static final int SYNTACTIC_TOKEN_COUNT = 9;
    public static final int PROGRAM = 0;
    public static final int APPLICATION = 1;
    public static final int LAMBDA = 2;
    public static final int _IF = 3;
    public static final int BEGIN = 4;
    public static final int QUOTE = 5;
    public static final int SET = 6;
    public static final int DEFINE = 7;
    public static final int MAKEANNOTATION = 8;
    public static final int LETREC = 9;
    public static final int FIX = 10;
    public static final int UNKNOWN = -1;
    public static final int REALTAIL = 1;
    public static final Map SYNTACTIC_TOKENS = new HashMap(9);
    static final Syntax SYN_QUOTE = CompilerConstants.syntax("quote", 5);
    static final Syntax SYN_PROGRAM = CompilerConstants.syntax("program", 0);
    static final Syntax SYN_BEGIN = CompilerConstants.syntax("begin", 4);
    static final Syntax SYN_IF = CompilerConstants.syntax("if", 3);
    static final Syntax SYN_DEFINE = CompilerConstants.syntax("define", 7);
    static final Syntax SYN_SET = CompilerConstants.syntax("set!", 6);
    static final Syntax SYN_LAMBDA = CompilerConstants.syntax("lambda", 2);
    static final Syntax SYN_LETREC = CompilerConstants.syntax("letrec", 9);
    static final Syntax SYN_FIX = CompilerConstants.syntax("fix", 10);
    static final Syntax SYN_ANNOT = CompilerConstants.syntax("annotate", 8);
    static final Syntax SYN_UNKNOWN = CompilerConstants.syntax("unknown", -1);
    static final Symbol VARNAME = Symbol.get("var-name");
    static final Symbol PROCNAME = Symbol.get("proc-name");
    static final Symbol _LETREC = Symbol.get("letrec");

    static Syntax syntax(String string, int n) {
        Syntax syntax = new Syntax(n);
        syntax.setName(Symbol.get(string));
        SYNTACTIC_TOKENS.put(string, syntax);
        SYNTACTIC_TOKENS.put(new Integer(n), syntax);
        return syntax;
    }

    static void extendenv(SymbolicEnvironment symbolicEnvironment, String string, Syntax syntax) {
        Symbol symbol = Symbol.get(string);
        symbolicEnvironment.define(symbol, syntax);
    }
}

