/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.MemoizedSymbol;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.reader.CharUtil;
import sisc.reader.Lexer;
import sisc.reader.Parser;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class Symbol
extends Value {
    public String symval;

    public static Symbol getUnique(String string) {
        return new Symbol(string);
    }

    public static Symbol intern(String string) {
        return MemoizedSymbol.intern(string);
    }

    public static Symbol get(String string) {
        return Symbol.get(string, false);
    }

    public static Symbol get(String string, boolean bl) {
        return Symbol.intern(bl ? string : string.toLowerCase());
    }

    public Symbol(String string) {
        this.symval = string;
    }

    public Symbol normalize() {
        return Symbol.get(this.symval.toLowerCase());
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append(this.symval);
    }

    private void slashify(ValueWriter valueWriter, boolean bl) throws IOException {
        for (int i = 0; i < this.symval.length(); ++i) {
            char c = this.symval.charAt(i);
            if (bl) {
                if (c == '|' || !Lexer.isPrintable(c)) {
                    valueWriter.append('\\').append(CharUtil.charToEscaped(c));
                    continue;
                }
                valueWriter.append(c);
                continue;
            }
            if (!Lexer.isIdentifierSubsequent(c)) {
                valueWriter.append('\\').append(CharUtil.charToEscaped(c));
                continue;
            }
            valueWriter.append(c);
        }
    }

    public int valueHashCode() {
        return this.symval.hashCode();
    }

    public boolean valueEqual(Value value) {
        return super.valueEqual(value) || value instanceof Symbol && ((Symbol)value).symval.equals(this.symval);
    }

    public void write(ValueWriter valueWriter) throws IOException {
        if ((valueWriter.caseSensitive() || this.symval.toLowerCase().equals(this.symval)) && !Lexer.contains(this.symval, Lexer.special_and_reserved) && (Parser.isPeculiarIdentifier(this.symval) || this.symval.length() > 0 && Lexer.isIdentifierStart(this.symval.charAt(0)))) {
            this.slashify(valueWriter, false);
        } else {
            valueWriter.append('|');
            this.slashify(valueWriter, true);
            valueWriter.append('|');
        }
    }

    public Symbol() {
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeUTF(this.symval);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.symval = deserializer.readUTF();
    }
}

