(module demo-app/models
    (demo-app
     demo-app:users
     demo-app:roles
     demo-app:registration_rate_group
     demo-app:registration_rate
     demo-app:timeslot
     demo-app:session
     demo-app:session_timeslot
     demo-app:socialfunction
     demo-app:hotel
     demo-app:hotelroom
     demo-app:dietaryrequirement
     demo-app:title
     demo-app:registration
     demo-app:registration_session
     demo-app:registration_socialfunction
     demo-app:registration_dietaryrequirement
     demo-app:registration_payment
     demo-app:registration_payment_email
     demo-app:application_data

     (with-demo-app-transaction call-with-simple-transaction-on)

     find-by-field
     get-application-data
     get-registration_rate_groups
     get-registration_rates
     get-rate-groups-for-ui
     get-timeslots-and-sessions
     get-socialfunctions-on-date
     get-hotel-date-options
     get-hotels
     get-hotelrooms
     get-hotels-for-ui
     get-dietaryrequirements
     get-title-options
     )

  (import srfi-1)
  (import srfi-19)
  (import lshift/db)
  (import demo-app/memoize)
  (import lshift/db-validated-fields)
  (import hashtable)

  (define-database demo-app
    (get-jndi-connection "SiteDb"))

  (define-database-table demo-app users (users (username) #f)
    ((username string)
     (password string)))

  (define-database-table demo-app roles (roles (username rolename) #f)
    ((username string)
     (rolename string)))

  (define-database-table demo-app registration_rate_group (registration_rate_group (position) #f)
    ((position int)
     (name string)))

  (define-database-table demo-app registration_rate (registration_rate (guid) make-new-guid-pk)
    ((guid guid)
     (name string)
     (price money)
     (rate_group int)
     (group_position int)
     (published string)))

  (define-database-table demo-app timeslot (timeslot (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (starttime datetime)
     (endtime datetime)))

  (define-database-table demo-app session (session (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (title string)))

  (define-database-table demo-app session_timeslot (session_timeslot () #f)
    ((session_guid guid)
     (timeslot_guid guid)))

  (define-database-table demo-app socialfunction (socialfunction (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (starttime datetime)
     (title string)
     (price money)))

  (define-database-table demo-app hotel (hotel (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (name string)
     (starcount int)
     (walkingdistance string)))

  (define-database-table demo-app hotelroom (hotelroom (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (hotel_guid guid)
     (roomtype string)
     (price money)))

  (define-database-table demo-app dietaryrequirement (dietaryrequirement (guid) make-new-guid-pk)
    ((guid guid)
     (published string)
     (name string)))

  (define-database-table demo-app title (title (title) #f)
    ((title string)))

  (define-database-table demo-app registration (registration (guid) make-new-guid-pk)
    ((guid guid)
     (title string)
     (firstname string)
     (lastname string)
     (company string)
     (jobtitle string)
     (address_line_1 string)
     (address_line_2 string)
     (address_line_3 string)
     (town string)
     (county string)
     (postcode string)
     (country string)
     (telephone string)
     (fax string)
     (email string)
     (mobile string)
     (rate_selection guid)
     (hotelroom_guid guid)
     (checkin date)
     (checkout date)
     (specialrequirements_hotel string)
     (companionname string)
     (specialrequirements_dietary string)))

  (define-database-table demo-app registration_session (registration_session () #f)
    ((registration_guid guid)
     (session_guid guid)))

  (define-database-table demo-app registration_socialfunction (registration_socialfunction () #f)
    ((registration_guid guid)
     (socialfunction_guid guid)))

  (define-database-table demo-app registration_dietaryrequirement (registration_dietaryrequirement
								   () #f)
    ((registration_guid guid)
     (dietaryrequirement_guid guid)))

  (define-database-table demo-app registration_payment (registration_payment
							(guid) make-new-guid-pk)
    ((guid guid)
     (registration_guid guid)
     (payment_type string)
     (encrypteddetail string)
     (processed bit)))

  (define-database-table demo-app registration_payment_email (registration_payment_email
							      (registration_payment_guid) #f)
    ((registration_payment_guid guid)
     (admin_email_address string)))

  (define-database-table demo-app application_data (application_data () #f)
    ((booking_deadline d-month-year-date)
     (conference_starttime d-month-year-date)
     (conference_endtime d-month-year-date)
     (hotelbooking_starttime d-month-year-date)
     (hotelbooking_endtime d-month-year-date)
     (conference_office_phone string)))

  (define-syntax with-demo-app-transaction
    (syntax-rules ()
      ((_ body ...)
       (call-with-simple-transaction-on demo-app
					(lambda (dummy)
					  body ...)))))

  (define (find-by-field field-name value results)
    (find (lambda (r) (equal? value (db-result-get r field-name))) results))

  (define-memoized-for-duration 30 (get-application-data)
    (db-select1 demo-app:application_data '() '()))

  (define-memoized-for-duration 30 (get-registration_rates)
    (db-select demo-app:registration_rate '((where (= published "published"))
					    (order-by (asc rate_group)
						      (asc group_position)))
	       '()))

  (define-memoized-for-duration 30 (get-registration_rate_groups)
    (db-select demo-app:registration_rate_group '((order-by (asc position))) '()))

  (define-memoized-for-duration 30 (get-rate-groups-for-ui)
    (let* ((groups (get-registration_rate_groups))
	   (rates (get-registration_rates)))
      `(rate-groups
	,@(filter-map (lambda (group)
			(let ((rates (filter (lambda (rate)
					       (= (db-result-get rate 'rate_group)
						  (db-result-get group 'position)))
					     rates)))
			  (and (pair? rates)
			       `(group
				 ,(ui-db-result/ro group)
				 ,@(map ui-db-result/ro rates)))))
		      groups))))

  (define-memoized-for-duration 30 (get-timeslots-and-sessions)
    (let* ((timeslots (db-select demo-app:timeslot '((where (= published "published"))
						     (order-by (asc starttime)))
				 '()))
	   (sessions (db-results->one-to-one (db-select demo-app:session
							'((where (= published "published")))
							'())
					     'guid #f))
	   (mapping (db-results->one-to-many (db-select demo-app:session_timeslot '() '())
					     'timeslot_guid 'session_guid)))
      (filter-map (lambda (timeslot)
		    (let ((sessions (map (lambda (session-guid)
					   (hashtable/get sessions session-guid))
					 (hashtable/get mapping
							(db-result-get timeslot 'guid)
							'()))))
		      (and (pair? sessions)
			   (list timeslot sessions))))
		  timeslots)))

  (define (get-socialfunctions-on-date d)
    (db-select demo-app:socialfunction '((where (= published "published")
						(= (convert "nvarchar" starttime "112")
						   (convert "nvarchar" (cast ?d datetime) "112"))))
	       `((d ,d))))

  (define-memoized-for-duration 30 (get-hotel-date-options)
    (let ((app-data (get-application-data)))
      `(options ,@(unfold (lambda (t)
			    (time>? t (db-result-get app-data 'hotelbooking_endtime)))
			  (lambda (t)
			    (list (date->string (time-monotonic->date t) "~e ~B ~Y")
				  (date->string (time-monotonic->date t) "~1")))
			  (lambda (t)
			    (add-duration t (make-time 'time-duration 0 86400)))
			  (db-result-get app-data 'hotelbooking_starttime)))))

  (define-memoized-for-duration 30 (get-hotels)
    (db-select demo-app:hotel '((where (= published "published"))) '()))

  (define-memoized-for-duration 30 (get-hotelrooms)
    (db-select demo-app:hotelroom '((where (= published "published"))) '()))

  (define-memoized-for-duration 30 (get-hotels-for-ui)
    (let* ((hotels (get-hotels))
	   (hotelrooms (db-results->one-to-many (get-hotelrooms) 'hotel_guid #f)))
      `(hotel-rows
	,@(filter-map (lambda (hotel)
			(let ((rooms (hashtable/get hotelrooms (db-result-get hotel 'guid) '())))
			  (and (pair? rooms)
			       `(row ,(ui-db-result/ro hotel)
				     ,@(map ui-db-result/ro rooms)))))
		      hotels))))

  (define-memoized-for-duration 30 (get-dietaryrequirements)
    (db-select demo-app:dietaryrequirement '((where (= published "published"))) '()))

  (define-memoized-for-duration 30 (get-title-options)
    `(options ,@(map (lambda (result) (db-result-get result 'title))
		     (db-select demo-app:title '((where (= published "published"))) '()))))

  )
