;; Generic site configuration
(emit-annotations #t)
(emit-debugging-symbols #t)

(let ([old-load load])
  (set! load (lambda (file)
	       (display (format "loading ~a ...\n" file))
               (display (format "loading ~a took ~a\n" file (cadr (time (old-load file))))))))

(let ([old-require-library require-library])
  (set! require-library (lambda (name)
			  (display (format "requiring ~a ...\n" name))
                          (let ([t (time (old-require-library name))])
                            (and (or (not (car t)) ;; old sisc - #f meant "I loaded something"
				     (pair? (car t))) ;; new sisc - "a list of things I loaded"
                                 (display (format "requiring ~a took ~a\n" name (cadr t))))))))


(require-library 'demo-app/library-requires)

(import lshift/mssql) ;; this actually installs the vendor bindings with the SISCweb code
(let ()
  (import lshift/xslt)
  (global-override-xslt-path! "xslt/"))

(require-library 'demo-app/memoize)
(require-library 'demo-app/models)
(import demo-app/models)

(require-library 'demo-app/system-actions)
(require-library 'demo-app/public-actions)

(module main-fc-handler
    ()
  (import siscweb/config)
  (import siscweb/error)
  (import lshift/error)
  (config/set-fc-hook! (lambda (m e)
			 (debug-dump-exception m e)
			 (send-error/back 500 "Internal server error"))))
(import main-fc-handler)

(module restart-handler
    ()
  (import lshift/config)
  (import siscweb/contcentric)
  (import lshift/xslt-ui)
  (set! missing-k-hook
    (lambda (path reset-k)
      (send/suspend (lambda (k-url k-resume)
		      (send-xslt/back `((error/expired ((restart-url ,k-url)))) '(data))))
      (reset-k))))
(import restart-handler)
