(module lshift/error
    (error+
     debug-let
     debug-dump-exception)

  (import debugging)
  (import srfi-13)
  (import string-io)

  (define (error+ msg . args)
    (error (string-concatenate (cons msg
				     (map (lambda (arg)
					    (string-append "; "
							   (with-output-to-string
							     (lambda () (write arg)))))
					  args)))))

  (define-syntax debug-let
    (syntax-rules ()
      ((_ which-let ((binding init) ...) body ...)
       (which-let ((binding (let ((temp init))
			      (pretty-print `(debug-let which-let binding ,temp))
			      (newline)
			      temp))
		   ...)
	 body ...))))

  (define (debug-dump-exception m e)
    (define (d . xs) (for-each (lambda (x) (display x (current-error-port))) xs))
    (d "\n===========================================================================\n")
    (d "SCHEME-LEVEL ERROR\n\n")
    (for-each (lambda (pair) (d (car pair)": "(cdr pair)"\n"))
	      m)
    (d "\nSTACK TRACE\n\n")
    (d (with-output-to-string (lambda () (print-stack-trace e))))
    (d "\n===========================================================================\n")))
