(module lshift/html-email
    (file->string
     file->byte-array
     sxml->html-email-body-part)

  (import s2j)
  (import lshift/email)
  (import lshift/mime-email)
  (import utils/sxml-tools)
  (import srfi-1)
  (import xxexpr)
  (import string-io)

  (define file->string
    (let ()
      (define-java-classes <java.lang.string>)
      (lambda (path)
	(->string (java-new <java.lang.string> (file->byte-array path))))))

  (define file->byte-array
    (let ((*chunk-length* 4096))
      (define-java-classes
	<java.lang.string>
	<java.lang.system>
	<java.io.buffered-input-stream>
	<java.io.file-input-stream>)
      (define-generic-java-methods
	(jread read)
	(jclose close)
	arraycopy)
      (define (make-chunk) (java-array-new <jbyte> *chunk-length*))
      (define jzero (->jint 0))
      (define jchunklength (->jint *chunk-length*))
      (lambda (path)
	(let* ((jpath (real-path (->jstring path)))
	       (istream (java-new <java.io.buffered-input-stream> (java-new <java.io.file-input-stream> jpath))))
	  (let loop ((reversed-chunks '())
		     (count 0))
	    (let* ((chunk (make-chunk))
		   (actually-read (->number (jread istream chunk jzero jchunklength))))
	      (if (= actually-read -1)
		  (let ((result (java-array-new <jbyte> count)))
		    (let loop ((chunks (reverse reversed-chunks))
			       (offset 0))
		      (if (null? chunks)
			  (begin
			    (jclose istream)
			    result)
			  (let ((chunk-size (caar chunks))
				(chunk (cdar chunks)))
			    (arraycopy (java-null <java.lang.system>)
				       chunk jzero result (->jint offset) (->jint chunk-size))
			    (loop (cdr chunks) (+ offset chunk-size))))))
		  (loop (cons (cons actually-read chunk) reversed-chunks)
			(+ count actually-read)))))))))

  (define (sxml->html-email-body-part sxml)
    (with-sxml sxml
      (let* ((root (select "/html-email/root"))
	     (plain-text ($ "/html-email/alternative"))
	     (parts (select "/html-email/part")))
	(build-mime-multipart
	 "alternative"
	 `(("text/plain" ,plain-text)
	   ,(build-mime-multipart
	     "related"
	     `(("text/html" ,(parameterize ((xml-empty-tags-mode #f)
					    (xml-double-quotes-mode #t))
			       (call-with-output-string
				(lambda (p)
				  (write-xxexpr (with-sxml root (select "root/html")) p)))))
	       ,@(map (lambda (part)
			(with-sxml part
			  (let ((mime-type ($ "part/@type"))
				(encoding ($ "part/@encoding"))
				(source-path ($ "part/@src"))
				(id ($ "part/@id")))
			    `(,mime-type
			      ,(if (string=? "" source-path)
				   ($ "part/node()")
				   (encode-jbyte-array encoding
						       (file->byte-array source-path)
						       #t))
			      (("Content-Transfer-Encoding" ,encoding)
			       ("Content-ID" ,(string-append "<" id ">")))))))
		      parts))))))))

  )
