(module lshift/mime-email
    (ensure-jbyte-array
     mime->bytes
     encode-jbyte-array
     build-mime-body-part
     build-mime-multipart
     set-mime-message-content)

  (import util/jndi)
  (import s2j)
  (import lshift/email)
  (import lshift/error)
  (import type-system)

  (define-java-classes
    <java.io.byte-array-output-stream>
    <javax.mail.multipart>
    <javax.mail.internet.internet-headers>
    <javax.mail.internet.mime-multipart>
    <javax.mail.internet.mime-body-part>
    <javax.mail.internet.mime-utility>)

  (define-generic-java-methods
    (jwrite write)
    (jflush flush)
    (jclose close)
    to-string
    to-byte-array
    encode
    add-header
    add-body-part
    get-bytes
    get-content-type
    (set-mime-message-content |setContent|))

  (define (encode-jbyte-array encoding bytes . as-string)
    (let* ((target-stream (java-new <java.io.byte-array-output-stream>))
	   (encoding-stream (encode (java-null <javax.mail.internet.mime-utility>)
				    target-stream
				    (->jstring encoding))))
      (jwrite encoding-stream bytes)
      (jflush encoding-stream)
      (jclose encoding-stream)
      (if (and (pair? as-string)
	       (car as-string))
	  (->string (to-string target-stream))
	  (to-byte-array target-stream))))

  (define (build-internet-headers headerdef)
    (let ((headers (java-new <javax.mail.internet.internet-headers>)))
      (for-each (lambda (def)
		  (add-header headers
			      (->jstring (first def))
			      (->jstring (second def))))
		headerdef)
      headers))

  (define (ensure-jbyte-array x)
    (if (string? x)
	(get-bytes (->jstring x))
	x))

  (define (build-mime-body-part part-definition)
    (cond
     ((pair? part-definition)
      (let ((content-type (first part-definition))
	    (body-jbyte-array (ensure-jbyte-array (second part-definition)))
	    (maybe-headerdefs (cddr part-definition)))
	(java-new <javax.mail.internet.mime-body-part>
		  (build-internet-headers
		   `(("Content-Type" ,content-type)
		     ,@(if (null? maybe-headerdefs)
			   '()
			   (car maybe-headerdefs))))
		  body-jbyte-array)))
     ((java-object? part-definition)
      (cond
       ((instance-of? part-definition <javax.mail.multipart>)
	(mime-multipart->mime-body-part part-definition))
       (else part-definition)))
     (else (error+ "build-mime-body-part: Illegal part-definition"
		   part-definition))))

  (define (build-mime-multipart subtype parts)
    (let ((multipart (if subtype
			 (java-new <javax.mail.internet.mime-multipart> (->jstring subtype))
			 (java-new <javax.mail.internet.mime-multipart>))))
      (for-each (lambda (part-definition)
		  (add-body-part multipart (build-mime-body-part part-definition)))
		parts)
      multipart))

  (define (mime-multipart->mime-body-part multipart)
    (build-mime-body-part (list (->string (get-content-type multipart))
				(mime->bytes multipart))))

  (define (mime->bytes thing)
    (define-generic-java-methods
      write-to
      to-byte-array)
    (define-java-classes
      <java.io.byte-array-output-stream>)
    (let ((s (java-new <java.io.byte-array-output-stream>)))
      (write-to thing s)
      (to-byte-array s)))

  )
