(module padding
    (make-padder
     pad-string
     pad-list)

  (import srfi-1)
  (import lshift/error)

  ;; Return a procedure that will pad a given object to the specified dimensions
  ;;
  ;; length-proc - a procedure that returns the length of the given object
  ;;
  ;; append-proc - a procedure that joins the padding and the existing contents of the object
  ;;
  ;; make-proc - a procedure that returns the type of containing
  ;;   object of a given length seeded with the give fill obj
  (define (make-padder length-proc append-proc make-proc)
    (lambda (containing-obj minw maxw fill-obj bias)
      (let ((l (length-proc containing-obj)))
	(cond
	 ((< l minw)
	  (let ((padding (make-proc (- minw l) fill-obj)))
	    (case bias
	      ((left) (append-proc padding containing-obj))
	      ((right) (append-proc containing-obj padding))
	      (else (error+ "pad: illegal bias, expected either left or right" bias)))))
	 ((> l maxw)
	  (error+ "pad: containing-obj longer than maximum width" containing-obj maxw))
	 (else
	  containing-obj)))))
      
  (define pad-string
    (make-padder string-length string-append make-string))

  (define pad-list
    (make-padder length append make-list))

  )