(module lshift/pgp-email
    (initialize-bc-crypto!
     make-pgp-encryptor
     pgp-encrypt
     send-test-message!)

  (import s2j)
  (import lshift/email)
  (import lshift/mime-email)
  (import lshift/error)
  (import type-system)

  (define-java-classes
    <net.lshift.icing.bouncy-castle-pgp-string-encryptor>)

  (define-generic-java-methods
    initialize
    encrypt)

  ;; Call this once, to set up the java.security.Security Provider
  ;; for Bouncy Castle.
  ;;
  (define (initialize-bc-crypto!)
    (initialize (java-null <net.lshift.icing.bouncy-castle-pgp-string-encryptor>)))

  (define (make-pgp-encryptor pkblock)
    (java-new <net.lshift.icing.bouncy-castle-pgp-string-encryptor>
	      (->jstring pkblock)))

  (define (pgp-encrypt encryptor message)
    (->string (encrypt encryptor (ensure-jbyte-array message))))

  (define (encrypted-mime-part encryptor part)
    (let ((encrypted-text (pgp-encrypt encryptor (mime->bytes (build-mime-body-part part)))))
      (build-mime-multipart "encrypted; protocol=\"application/pgp-encrypted\""
			    `(("application/pgp-encrypted" "Version: 1\r\n")
			      ("application/octet-stream; name=\"encrypted.asc\""
			       ,encrypted-text)))))

  (define (send-test-message! recipient)

    (import util/jndi)

    (define (safe-jndi/lookup key)
      (let ((jvalue (jndi/lookup key)))
	(or jvalue
	    (error+ "JNDI lookup failed - missing key?" key))))

    (define (tony-encryptor)
      (make-pgp-encryptor "-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.2 (GNU/Linux)

mQGiBED7un8RBACaMVWms+ERBYTxIxTHC+UGuZyxTHQcb1bYIhU9pvJcUJUUSt2W
ER/av/dinaoAk+/RIj5OYKIOVwJOV4KpZkvlH4A3/sEnNr+357btlQl/4N7JKei3
cLQ5Pr5yTfjhqDNndUknR7z8j0f2eFbV8nQCGrq1NOIMdV4fLr6SwQoqmwCg9hF8
kTti6bS84tzpNFnmYREIQpsD/Ar5dgQCagDt+qpjRxEAmM3EVsj33ApuFJdASANJ
Lsk8rGXCp33kb4+vXf6svQ/3WrKKf7fBfehPHv6XovNZd0tS6N5X25+4nEkKalgb
I4As785Y6jioFmy9Nz/je6EQyat1Ygi0c49l1FF9s7mwZ2JsJLYxDyYTv1h6wZWA
K5lCBACFgLy2sLUeC3N9oNDQQDOWUsVaRSx6QG3RDG37VIMPoB6NVAO6Mbb2k/JW
MRazHCfuu/LVJKtnoH6k/UVBaZA1EBaSE9vgeKVXATYFpleq8DiDrdxrBcjZV+Qq
BJFdcQ1MSRaOxtf5MizoHcnl5a26S1lat0Ex+I4kgysCffv6P7Q+VG9ueSBHYXJu
b2NrLUpvbmVzIChHUEcga2V5LCBhdCBsc2hpZnQubmV0KSA8dG9ueWdAbHNoaWZ0
Lm5ldD6IXgQTEQIAHgUCQPu6fwIbAwYLCQgHAwIDFQIDAxYCAQIeAQIXgAAKCRDy
mx3TC5gGlrm2AKCUEFKRuFrNsxgK+M38cy6di5hoXgCgnNFC5c/7uwW+kevFfd7B
BpjPcve5AQ0EQPu6hRAEANvfKi0sehDRUUpCzEMmVp3IblW/ZUvM5aAyIaHCAhgg
WOBzxDBwO778BruI+/H3ZR+i61dDjTILpjLdM8OHCk2lnEaE6hdzJ8zqQwT8qMFn
29W5/c73sItGe+h2bFB+Dj9NSeIvU6B3pOjfaTC2mCs0KVr9NLa9p/SPMnXwAxDP
AAMFBACS23tsLLo9eshtcuE3mOYc1s0vAstpvXfrnDwE4zVlXrrBKTZBb3EyIids
3Q0TzRzF6TpUAHVxcau6hQug0OolPI1eNUrjVcSXs4hUplIMvedLHNhyhxaDSErv
I40IkP9/DHojQYYf3i1ag5S+2feKTygqXTMxAXUsqAoQS/rlmYhJBBgRAgAJBQJA
+7qFAhsMAAoJEPKbHdMLmAaWxIwAoOfErs677BaF4FWyXBoKb0RkBl90AJkBBfir
3QaXjZepuOZ6Z6MgCtbnPA==
=QE2a
-----END PGP PUBLIC KEY BLOCK-----
"))

    (let* ((message (make-email-message (safe-jndi/lookup "java:/comp/env/mail/Session")
					"A test message"
					`((to ,recipient))))
	   (body (build-mime-multipart #f
				       `(,(build-mime-multipart "alternative"
								`(("text/plain" "foo")
								  ("text/html" "<i>foo</i>")))
					 ,(encrypted-mime-part
					   (tony-encryptor)
					   (build-mime-multipart #f
								 `(("text/plain" "one")
								   ("text/html" "<h1>two</h1>"))))
					 ,(encrypted-mime-part
					   (tony-encryptor)
					   (build-mime-body-part `("text/html" "here")))))))
      (set-mime-message-content message body)
      (send-email message))))
