(require-library 'lshift/unit-test)
(import unit-test)

(call-with-new-test-run
 (lambda ()
   (test-suite "unit-test-test-suite"
	       `(
		 ,(test-case "test-equivalence-symbol"
			     (lambda ()
			       (assert-equivalence eqv? 'a 'a)))

		 ,(test-case "test-equivalence-list"
			     (lambda ()
			       (assert-equivalence equal? '(1 2 3 4 5 6) '(1 2 3 4 5 6))))

		 ,(test-case "test-equivalence-fail"
			     (lambda ()
			       (assert-false
				(lambda ()
				  (eqv? 'a 'b)))))
              
		 ,(test-case "test-error"
			     (lambda ()
			       (assert-error
				(lambda ()
				  (assert-equivalence eqv? 'a 'b)))))

		 ,(test-case "test-error-fail"
			     (lambda ()
			       (assert-error
				(lambda ()
				  (assert-error
				   (lambda ()
				     (assert-equivalence eqv? 'a 'a)))))))

		 ))))
