use %db.name*

INSERT INTO [%db.name*].[%db.owner*].[registration_rate_group] (position, name)
	 VALUES (1, 'Early bird rates')
INSERT INTO [%db.name*].[%db.owner*].[registration_rate_group] (position, name)
	 VALUES (2, 'Standard rates')

INSERT INTO [%db.name*].[%db.owner*].[registration_rate] (rate_group, group_position, name, price)
	VALUES (1, 1,  '2 day member', 10.95)
INSERT INTO [%db.name*].[%db.owner*].[registration_rate] (rate_group, group_position, name, price)
	VALUES (1, 2,  '2 day non-member', 12.95)

INSERT INTO [%db.name*].[%db.owner*].[registration_rate] (rate_group, group_position, name, price)
	VALUES (2, 1,  '2 day member', 20.45)
INSERT INTO [%db.name*].[%db.owner*].[registration_rate] (rate_group, group_position, name, price)
	VALUES (2, 2,  '2 day non-member', 24.95)
INSERT INTO [%db.name*].[%db.owner*].[registration_rate] (rate_group, group_position, name, price)
	VALUES (2, 3,  'VIP Rate', 16.45)

INSERT INTO [%db.name*].[%db.owner*].[timeslot] (guid, starttime, endtime)
	VALUES ('D02988EC-1842-4087-B323-BB1EB725DBED','2007-01-04 12:00:00','2007-01-04 13:00:00')
INSERT INTO [%db.name*].[%db.owner*].[timeslot] (guid, starttime, endtime)
	VALUES ('FF84AD7D-FF27-4926-8AD6-1A2A738D5748','2007-01-04 14:50:00','2007-01-04 15:50:00')
INSERT INTO [%db.name*].[%db.owner*].[timeslot] (guid, starttime, endtime)
	VALUES ('B7B838CF-01C0-4253-A3BA-241AC3F348F7','2007-01-04 16:20:00','2007-01-04 17:20:00')
INSERT INTO [%db.name*].[%db.owner*].[timeslot] (guid, starttime, endtime)
	VALUES ('DE1B243F-8BA5-43CE-8BC2-30B67713EB00','2007-01-05 11:00:00','2007-01-05 12:00:00')
INSERT INTO [%db.name*].[%db.owner*].[timeslot] (guid, starttime, endtime)
	VALUES ('94F392C9-7478-4B33-9D56-060CF4ED3C05','2007-01-05 13:45:00','2007-01-05 14:45:00')

INSERT INTO [%db.name*].[%db.owner*].[session] (guid, title)
	VALUES ('45DC38EA-5411-499F-B9CC-1121516F3A58', 'Item 1')
INSERT INTO [%db.name*].[%db.owner*].[session] (guid, title)
	VALUES ('C2FA6653-D21B-4823-900F-D7738BEDDDF8', 'Item 2')
INSERT INTO [%db.name*].[%db.owner*].[session] (guid, title)
	VALUES ('19BB6C1B-DF5F-4103-958F-80B0AE2B9884', 'Long Item 3')
INSERT INTO [%db.name*].[%db.owner*].[session] (guid, title)
	VALUES ('FFDE0892-FD5C-486C-A501-E98681A2CDE6', 'Item 4')
INSERT INTO [%db.name*].[%db.owner*].[session] (guid, title)
	VALUES ('DD66A1A5-0DB5-48B6-8951-2D961229C7DD', 'Item 5')

INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('45DC38EA-5411-499F-B9CC-1121516F3A58', 'D02988EC-1842-4087-B323-BB1EB725DBED')
INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('C2FA6653-D21B-4823-900F-D7738BEDDDF8', 'FF84AD7D-FF27-4926-8AD6-1A2A738D5748')
INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('19BB6C1B-DF5F-4103-958F-80B0AE2B9884', 'B7B838CF-01C0-4253-A3BA-241AC3F348F7')
INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('19BB6C1B-DF5F-4103-958F-80B0AE2B9884', 'FF84AD7D-FF27-4926-8AD6-1A2A738D5748')
INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('FFDE0892-FD5C-486C-A501-E98681A2CDE6', 'B7B838CF-01C0-4253-A3BA-241AC3F348F7')
INSERT INTO [%db.name*].[%db.owner*].[session_timeslot] (session_guid, timeslot_guid)
	VALUES ('DD66A1A5-0DB5-48B6-8951-2D961229C7DD', '94F392C9-7478-4B33-9D56-060CF4ED3C05')

INSERT INTO [%db.name*].[%db.owner*].[socialfunction] (starttime, title, price)
	VALUES ('2007-01-04 19:30', 'Title of the social event here', 50)
INSERT INTO [%db.name*].[%db.owner*].[socialfunction] (starttime, title, price)
	VALUES ('2007-01-04 20:30', 'Another social event', 50)
INSERT INTO [%db.name*].[%db.owner*].[socialfunction] (starttime, title, price)
	VALUES ('2007-01-05 17:45', 'Third social event', 150)

INSERT INTO [%db.name*].[%db.owner*].[hotel] (guid, name, starcount, walkingdistance)
	VALUES ('7D6A8309-16A5-423F-8F1B-0D073D627ECB', 'Hotel A', 3, 'Not far')
INSERT INTO [%db.name*].[%db.owner*].[hotel] (guid, name, starcount, walkingdistance)
	VALUES ('DED80BCF-7ACC-4829-9B12-AB5CD61A78C0', 'Hotel B', 4, 'Quite a way')

INSERT INTO [%db.name*].[%db.owner*].[hotelroom] (hotel_guid, roomtype, price)
	VALUES ('7D6A8309-16A5-423F-8F1B-0D073D627ECB', 'Single room', 80)
INSERT INTO [%db.name*].[%db.owner*].[hotelroom] (hotel_guid, roomtype, price)
	VALUES ('7D6A8309-16A5-423F-8F1B-0D073D627ECB', 'Double room', 130)
INSERT INTO [%db.name*].[%db.owner*].[hotelroom] (hotel_guid, roomtype, price)
	VALUES ('DED80BCF-7ACC-4829-9B12-AB5CD61A78C0', 'Royal room', 300)

INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('No Dairy')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('Vegan')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('Vegetarian')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('Gluten Free')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('No Fish')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('No Nuts')
INSERT INTO [%db.name*].[%db.owner*].[dietaryrequirement] (name) VALUES ('No Pork')

INSERT INTO [%db.name*].[%db.owner*].[title] (title) VALUES ('Mr')
INSERT INTO [%db.name*].[%db.owner*].[title] (title) VALUES ('Mrs')
INSERT INTO [%db.name*].[%db.owner*].[title] (title) VALUES ('Miss')
INSERT INTO [%db.name*].[%db.owner*].[title] (title) VALUES ('Ms')
INSERT INTO [%db.name*].[%db.owner*].[title] (title) VALUES ('Dr')

INSERT INTO [%db.name*].[%db.owner*].[application_data]
	VALUES ('2006-12-31',
		'2007-01-04',
		'2007-01-05',
		'2007-01-03',
		'2007-01-06',
		'020 DEV NULL')

UPDATE registration_rate SET published = 'published'
UPDATE timeslot SET published = 'published'
UPDATE session SET published = 'published'
UPDATE socialfunction SET published = 'published'
UPDATE hotel SET published = 'published'
UPDATE hotelroom SET published = 'published'
UPDATE dietaryrequirement SET published = 'published'
UPDATE title SET published = 'published'

GO

-- **************************************************
