(define-method disassemble <function>
  (lambda (f)
    (define (literal n) (indexed-ref f n))
    (define (op ip ip-delta) (binary-ref f (+ ip ip-delta)))
    (define (signed16->unsigned16 n)
      (set! n (modulo n 65536))
      (if (>= n 32768)
	  (- n 65536)
	  n))
    (define (relofs ip ip-delta)
      (+ (signed16->unsigned16 (+ (* 256 (op ip (+ ip-delta 1)))
				  (op ip ip-delta)))
	 (+ ip 1)))
    (define (instr ip ip-delta instruc)
      (cons (cons ip instruc) (from (+ ip ip-delta))))
    (define (from ip)
      (if (>= ip (binary-length f))
	  '()
	  (case (op ip 0)
	    ((#x00) (instr ip 2 (list 'ldc (literal (op ip 1)))))
	    ((#x01) (instr ip 3 (list 'ldl (op ip 1) (op ip 2))))
	    ((#x02) (instr ip 2 (list 'lds (op ip 1))))
	    ((#x03) (instr ip 2 (list 'ldg (literal (op ip 1)))))
	    
	    ((#x10) (instr ip 3 (list 'stl (op ip 1) (op ip 2))))
	    ((#x11) (instr ip 2 (list 'sts (op ip 1))))
	    ((#x12) (instr ip 2 (list 'stg (literal (op ip 1)))))
	    ((#x13) (instr ip 4 (list 'stln
				      (op ip 1)
				      (op ip 2)
				      (literal (op ip 3)))))
	    
	    ((#x20) (instr ip 1 (list 'push)))
	    ((#x21) (instr ip 1 (list 'pop)))
	    
	    ((#x30) (instr ip 2 (list 'enter (op ip 1))))
	    ((#x31) (instr ip 1 (list 'exit)))
	    
	    ((#x40) (instr ip 3 (list 'j (relofs ip 1))))
	    ((#x41) (instr ip 3 (list 'jf (relofs ip 1))))
	    ((#x42) (instr ip 3 (list 'jt (relofs ip 1))))
	    ((#x43) (instr ip 3 (list 'je (relofs ip 1))))
	    
	    ((#x50) (instr ip 2 (list 'call (op ip 1))))
	    ((#x51) (instr ip 2 (list 'tail (op ip 1))))
	    ((#x52) (instr ip 2 (list 'callnm (op ip 1))))
	    ((#x53) (instr ip 2 (list 'tailnm (op ip 1))))
	    ((#x54) (instr ip 1 (list 'ret)))
	    
	    ((#x60) (instr ip 2 (list 'lambda
				      (literal (op ip 1)))))
	    )))
    (from 0)))
