; <hash-table>
; 6 October, 1997

; (make <hash-table> [size] [predicate])
;
; (get <hash-table> key) => value
; (put <hash-table> key value) => value

(define-class <hash-table> <object> (table size preds))

(define <hash-table>:predicates `((,eq? . #(,eq? ,assq ,hash-for-eq))
				  (,equal? . #(,equal? ,assoc ,hash-for-equal))))

(define <hash-table>:size 127)
(define <hash-table>:delta 256)
(define <hash-table>:pred eq?)

(define-method initialize <hash-table>
  (lambda (self . args)
    (let* ((alen (list-length args))
	   (size (if (= alen 0) <hash-table>:size (car args)))
	   (pred (if (< alen 2) <hash-table>:pred (cadr args)))
	   (preds (assq pred <hash-table>:predicates)))
      (set! preds
	    (if preds
		(cdr preds)
		(raise-exception 'predicate-not-valid-for-hash-table pred)))
      (set-table! self (make <vector> size))
      (set-size! self 0)
      (set-preds! self preds)
      self)))

(define-method <hash-table>:find-row <hash-table>
  (lambda (self key)
    (let* ((t (table self))
	   (hv (abs (modulo ((indexed-ref (preds self) 2) key) (indexed-length t)))))
      (cons hv
	    (indexed-ref t hv)))))

(define-method get <hash-table>
  (lambda (self key)
    (let* ((info (<hash-table>:find-row self key))
	   (row (cdr info))
	   (cell ((indexed-ref (preds self) 1) key row)))
      (and cell
	   (cdr cell)))))

(define-method put <hash-table>
  (lambda (self key val)
    (let* ((info (<hash-table>:find-row self key))
	   (hv (car info))
	   (row (cdr info))
	   (cell ((indexed-ref (preds self) 1) key row)))
      (if cell
	  (set-cdr! cell val)
	  (indexed-set! (table self) hv (cons (cons key val) row)))
      val)))

(define-method print-string <hash-table>
  (lambda (self w)
    "#<hashtable>"))
