; Macro expansion facility.
;
; Please note that macros are *NOT* available within this source file!
; Thus, among other things, (define (func arg arg) ...) is illegal.
; Use (define func (lambda (arg arg) ...)) instead.

(define *user-macros* '())

(define macro-expand
  (lambda (expr)
    (if (instance? expr <pair>)
	(case (car expr)
	  ((define)
	   (if (instance? (cadr expr) <pair>)
	       (list 'define (caadr expr)
		     (apply list 'lambda (cdadr expr) (map macro-expand (cddr expr))))
	       (list 'define (cadr expr) (macro-expand (caddr expr)))))
	  ((lambda)
	   (apply list 'lambda (cadr expr) (map macro-expand (cddr expr))))
	  ((let let* letrec)
	   (let ((transform-bindings (lambda (bindings)
				       (map (lambda (binding)
					      (list (car binding) (macro-expand (cadr binding))))
					    bindings))))
	     (if (instance? (cadr expr) <pair>)
		 (apply list (car expr) (transform-bindings (cadr expr))
			(map macro-expand (cddr expr)))
		 (apply list (car expr) (cadr expr) (transform-bindings (caddr expr))
			(map macro-expand (cdddr expr))))))
	  ((case)
	   (apply list 'case (macro-expand (cadr expr))
		  (map (lambda (case-stmt) (cons (car case-stmt)
						 (map macro-expand (cdr case-stmt))))
		       (cddr expr))))
	  ((begin)
	   (apply list 'begin (map macro-expand (cdr expr))))
	  ((quote)
	   expr)
	  (else
	   (let ((macro-binding (assq (car expr) *user-macros*)))
	     (if macro-binding
		 (macro-expand (apply (cdr macro-binding) (cdr expr)))
		 (cons (car expr)
		       (map macro-expand (cdr expr)))))))
	expr)))

(define macro-expand-pre-eval
  (lambda (expr)
    (if (and (instance? expr <pair>)
	     (eq? (car expr) 'define-macro))
	(let* ((template (cadr expr))
	       (name (car template))
	       (args (cdr template))
	       (body (cddr expr)))
	  (let ((transformer ((compile (macro-expand (apply list 'lambda args body)))))
		(binding (assq name *user-macros*)))
	    (if binding
		(set-cdr! binding transformer)
		(set! *user-macros* (cons (cons name transformer)
					  *user-macros*))))
	  '(quote #t))
	(macro-expand expr))))

(define macro-expanding-read-from
  (lambda (stream)
    (let ((expr (read-from stream)))
      (macro-expand-pre-eval expr))))

(define macro-expanding-primitive-load
  (lambda (filename)
    (if (not (file-exists? filename))
	#f
	(let ((s (make <file-stream> filename)))
	  (let loading-loop ((expr (macro-expanding-read-from s)))
	    (if (stream-at-eof? s)
		(begin
		  (close s)
		  #t)
		(begin
		  ((compile expr))
		  (loading-loop (macro-expanding-read-from s)))))))))

(set! *features* (cons 'macro *features*))
