/* $Id: class.c,v 1.2 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"
#include "bytecode.h"
#include "function.h"
#include "thread.h"
#include "vector.h"

#include <string.h>

OBJECT class_class;

void init_class(void) {
    class_class = getmem(sizeof(Object) +
                         CLS_SIZE * sizeof(OBJECT) +
                         3 * sizeof(char));
    register_root(&class_class, 1);

    SETNEXTOBJ(class_class, all_objects);
    all_objects = class_class;

    SETMARK(class_class, 0);
    SETNUMIDX(class_class, 0);
    SETNUMBIN(class_class, 3);
    SETCLASS(class_class, class_class);

    SET(class_class, CLS_NUMIVAR, MKNUM(CLS_SIZE));
    SET(class_class, CLS_SUPER, object_class);
    SET(class_class, CLS_IVARNAMES, NULL);          /* Fill in later? */

    BSET(class_class, 0, 1);    /* Number of next subclass */
    BSET(class_class, 1, 1);    /* First subclass of <object> */
    BSET(class_class, 2, 0);    /* End of inheritance chain */
}

OBJECT newclass(OBJECT super, long numivar, OBJECT ivarnames) {
    word lastpos = strlen(BIDX(super, 1));
    OBJECT obj = NewObject(class_class, 0, lastpos + 3);

    strcpy(BIDX(obj, 1), BIDX(super, 1));

    BSET(obj, lastpos+1, BGET(super, 0));
    BSET(obj, lastpos+2, 0);

    BSET(obj, 0, 1);
    BSET(super, 0, BGET(super, 0) + 1);

    SET(obj, CLS_SUPER, super);
    SET(obj, CLS_NUMIVAR, MKNUM(numivar + NUM(GET(super, CLS_NUMIVAR))));
    SET(obj, CLS_IVARNAMES, ivarnames);

    return obj;
}

/* Methods */

PRIVATE OBJECT class_getgetter(OBJECT cls, OBJECT name) {
    char func_code[] = {
        OP_LOCALREF, 0, 0,          /* acc = self */
        OP_SLOTREF, 0,              /* acc = self->slot (to be filled in) */
        OP_RETURN
    };
    OBJECT curr = GET(cls, CLS_IVARNAMES);
    word num = 0;

    while (curr != NULL) {
        if (CAR(curr) == name)
            break;

        curr = CDR(curr);
        num++;
    }

    if (curr == NULL) {
        raise_exception("slot-accessor-unavailable",
                        newvector(2, 1, cls, name));
        return NULL;
    }

    func_code[4] = (char) NUM(GET(GET(cls, CLS_SUPER), CLS_NUMIVAR)) +
                   (char) num;

    return newfunc(NULL, NULL, 1, 6, func_code, "generic-slot-getter");
}

PRIVATE OBJECT class_getsetter(OBJECT cls, OBJECT name) {
    char func_code[] = {
        OP_LOCALREF, 0, 0,          /* acc = self */
        OP_PUSH,
        OP_LOCALREF, 0, 1,          /* acc = value */
        OP_SLOTSET, 0,              /* self->slot = value */
        OP_RETURN
    };
    OBJECT curr = GET(cls, CLS_IVARNAMES);
    word num = 0;

    while (curr != NULL) {
        if (CAR(curr) == name)
            break;

        curr = CDR(curr);
        num++;
    }

    if (curr == NULL) {
        raise_exception("slot-mutator-unavailable",
                        newvector(2, 1, cls, name));
        return NULL;
    }

    func_code[8] = (char) NUM(GET(GET(cls, CLS_SUPER), CLS_NUMIVAR)) +
                   (char) num;

    return newfunc(NULL, NULL, 2, 10, func_code, "generic-slot-setter");
}

PRIVATE OBJECT class_simple_make(OBJECT cls, OBJECT nidx, OBJECT nbin) {
    return NewObject(cls, (word) NUM(nidx), (word) NUM(nbin));
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_class(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(class_class, NULL);

    AM("compute-slot-getter", class_getgetter, 2);
    AM("compute-slot-setter", class_getsetter, 2);
    AM("simple-make", class_simple_make, 3);

    deregister_root(1);
}

