/* $Id: file.c,v 1.6 1998/04/05 10:33:48 tonyg Exp $ */

#include <string.h>

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"
#include "symbol.h"
#include "string.h"
#include "file.h"
#include "thread.h"
#include "buffer.h"
#include "scan.h"
#include "parse.h"
#include "filescan.h"
#include "stream.h"

OBJECT file_class;

#define GETFP(o)    (* ((FILE **) BIDX(o, 0)))
#define SETFP(o,f)  (* ((FILE **) BIDX(o, 0)) = (f))

PRIVATE OBJECT file_initialise(OBJECT self, OBJECT name); /* Prototype */

void init_file(void) {
    OBJECT f;

    file_class = newclass(stream_class, FILE_SIZE, NULL);

    SET(newsym("<file-stream>"), SYM_VALUE, file_class);

    f = NewObject(file_class, FILE_SIZE, sizeof(FILE *));
    SETFP(f, stdin);
    SET(newsym("standard-input"), SYM_VALUE, f);
    SET(f, FILE_NAME, newstring("standard-input"));

    f = NewObject(file_class, FILE_SIZE, sizeof(FILE *));
    SETFP(f, stdout);
    SET(newsym("standard-output"), SYM_VALUE, f);
    SET(f, FILE_NAME, newstring("standard-output"));
}

/* Methods */

PRIVATE OBJECT file_printstr(OBJECT file, OBJECT w) {
  char buf[1024];
  sprintf(buf, "#<file %s>", BIDX(GET(file, FILE_NAME), 0));
  return newstring(buf);
}

PRIVATE OBJECT file_initialise(OBJECT self, OBJECT name) {
    FILE *f;

    if (!instance(name, string_class))
        return undefined;

    f = fopen(BIDX(name,0), "r+b");

    if (f == NULL)
        f = fopen(BIDX(name, 0), "w+b");

    if (f == NULL)
      f = fopen(BIDX(name, 0), "r");

    if (f == NULL) {
        raise_exception("could-not-open", name);
        return undefined;
    }

    self = NewObject(CLASS(self), CLSSIZE(self), sizeof(FILE *));

    SETFP(self, f);
    SET(self, FILE_NAME, name);

    return self;
}

PRIVATE OBJECT file_close(OBJECT self) {
    if (GETFP(self) != NULL) {
        fclose(GETFP(self));
        SETFP(self, NULL);
    }

    return true;
}

PRIVATE OBJECT file_read_chars(OBJECT self, OBJECT count) {
    char *buf = getmem((word) NUM(count) + 1);
    OBJECT result;
    int nread;

    nread = fread(buf, sizeof(char), (word) NUM(count), GETFP(self));
    buf[(word) NUM(count)] = '\0';

    if (nread > 0) {
        result = NewObject(string_class, 0, nread + 1);
        memcpy(BIDX(result, 0), buf, nread + 1);
    } else
        result = NULL;

    freemem(buf);

    return result;
}

PRIVATE OBJECT file_write(OBJECT self, OBJECT count, OBJECT chars) {
    int n = (word) NUM(count);

    if (NUMBIN(chars) < n)
        n = NUMBIN(chars);

    n = fwrite(BIDX(chars, 0), sizeof(char), n, GETFP(self));

    return MKNUM(n);
}

PRIVATE OBJECT file_seek(OBJECT self, OBJECT pos, OBJECT whence) {
    int w;

    if (whence == newsym("cur"))
        w = SEEK_CUR;
    else if (whence == newsym("end"))
        w = SEEK_END;
    else
        w = SEEK_SET;

    return MKNUM(fseek(GETFP(self), NUM(pos), w));
}

PRIVATE OBJECT file_tell(OBJECT self) {
    return MKNUM(ftell(GETFP(self)));
}

PRIVATE OBJECT file_eof(OBJECT self) {
    return feof(GETFP(self)) ? true : false;
}

PRIVATE OBJECT file_ungetc(OBJECT self, OBJECT ch) {
    ungetc(BGET(ch, 0), GETFP(self));
    return true;
}

PRIVATE OBJECT file_flush(OBJECT self) {
    fflush(GETFP(self));
    return true;
}

PRIVATE OBJECT file_read(OBJECT self) {
    SCANSTATE s = NULL;
    PARSER p = NULL;
    OBJECT obj = NULL;

    temp_register(&obj, 1);
    s = newscanner(GETFP(self), file_peek, file_drop);
    p = newparser(scan, s);

    obj = parse(p);

    if (obj == undefined)
        obj = GET(newsym("%%the-eof-object"), SYM_VALUE);

    killparser(p);
    killscanner(s);
    deregister_root(1);

    return obj;
}

PRIVATE OBJECT file_descriptor(OBJECT self) {
  return MKNUM(fileno(GETFP(self)));
}

PRIVATE OBJECT string_file_exists(OBJECT self) {
    FILE *f = fopen(BIDX(self, 0), "r");

    if (f == NULL)
        return false;

    fclose(f);
    return true;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)
#define AMS(n,f,a)  addmeth(n,f,a,cls)

void init_meth_file(void) {
    OBJECT cl = NULL;
    OBJECT cls = NULL;
    temp_register(&cl, 1);
    temp_register(&cls, 1);
    cl = cons(file_class, NULL);
    cls = cons(string_class, NULL);

    AM("print-string", file_printstr, 2);
    AM("initialize", file_initialise, 2);
    AM("close", file_close, 1);
    AM("read-chars-from", file_read_chars, 2);
    AM("write-chars-to", file_write, 3);
    AM("stream-seek", file_seek, 3);
    AM("stream-tell", file_tell, 1);
    AM("stream-at-eof?", file_eof, 1);
    AM("stream-ungetc", file_ungetc, 2);
    AM("stream-flush", file_flush, 1);
    AM("read-from", file_read, 1);
    AM("unix-file-descriptor", file_descriptor, 1);

    AMS("file-exists?", string_file_exists, 1);

    deregister_root(2);
}

