/* $Id: function.c,v 1.4 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "function.h"
#include "thread.h"
#include "prim.h"
#include "pair.h"
#include "vector.h"
#include "symbol.h"
#include "gf.h"

#include <string.h>

OBJECT function_class;

void init_function(void) {
    function_class = newclass(object_class, FUNC_SIZE, NULL);
    register_root(&function_class, 1);
}

OBJECT newfunc(OBJECT env, OBJECT litlist, long argc,
               long len, char *buf, char *name) {
    long litlen = list_length(litlist);
    OBJECT func = NewObject(function_class, (word) litlen, (word) len);
    word i;

    for (i = 0; i < (word) litlen; i++) {
        ISET(func, i, CAR(litlist));
        litlist = CDR(litlist);
    }

    memcpy(BIDX(func, 0), buf, (word) len);

    SET(func, FUNC_ENV, env);
    SET(func, FUNC_ARGC, MKNUM(argc));

    if (name != NULL) {
        temp_register(&func, 1);
        SET(func, FUNC_NAME, newsym(name));
        deregister_root(1);
    } else
        SET(func, FUNC_NAME, NULL);

    return func;
}

OBJECT instantiate_template(OBJECT template, OBJECT env) {
    OBJECT func = NewObject(function_class, NUMIDX(template), NUMBIN(template));
    word i;

    for (i = 0; i < NUMIDX(template); i++)
        ISET(func, i, IGET(template, i));

    memcpy(BIDX(func, 0), BIDX(template, 0), NUMBIN(template));

    SET(func, FUNC_ENV, env);
    SET(func, FUNC_ARGC, GET(template, FUNC_ARGC));

    return func;
}

char *func_name(OBJECT func) {
    if (instance(func, prim_class))
        return BIDX(GET(func, PRIM_NAME), 0);
    else if (instance(func, function_class) && GET(func, FUNC_NAME) != NULL)
        return BIDX(GET(func, FUNC_NAME), 0);
    else
        return "<unnamed-function>";
}

/* Methods */

PRIVATE OBJECT func_fork(OBJECT func) {
    OBJECT R[2];

    R[0] = R[1] = NULL;
    temp_register(R, 2);

    unblock(R[0] = newthread());

    R[1] = newvector(0, 0);
    R[1] = cons(R[1], GET(func, FUNC_ENV));

    push_call(R[0], func, NULL, R[1]);

    SET(R[0], THR_HANDLER_CHAIN, GET(getcurrthr(), THR_HANDLER_CHAIN));

    deregister_root(1);
    return R[0];
}

PRIVATE OBJECT func_install(OBJECT func) {
    OBJECT thread = getcurrthr();

    SET(thread, THR_HANDLER_CHAIN,
        cons(func, GET(thread, THR_HANDLER_CHAIN)));

    return true;
}

PRIVATE OBJECT func_remove(void) {
    OBJECT thread = getcurrthr();
    OBJECT chain = GET(thread, THR_HANDLER_CHAIN);

    if (chain != NULL)
        SET(thread, THR_HANDLER_CHAIN, CDR(chain));

    return (chain == NULL) ? false : true;
}

PRIVATE OBJECT func_callcc(OBJECT func) {
    OBJECT frame = NULL;
    OBJECT thread = getcurrthr();
    OBJECT curr_gf = NULL;

    temp_register(&frame, 1);

    frame = newvector(1, 0);
    push_call(thread, NULL, NULL, NULL);
    ISET(frame, 0, getcont(thread));

    if (instance(func, gf_class)) {
        OBJECT method = matchmethods(func, frame, 0, NULL);

        if (method == NULL) {
            raise_exception("method-not-found", func);
            deregister_root(1);
            return NULL;
        }

        curr_gf = func;
        func = method;
    }

    if (instance(func, function_class))
        SET(thread, THR_ENV, cons(frame, GET(func, FUNC_ENV)));
    else if (instance(func, prim_class))
        SET(thread, THR_ENV, frame);
    else if (instance(func, continuation_class)) {
        setcont(thread, func);
        pop_call(thread);
        deregister_root(1);
        return IGET(frame, 0);
    } else {
        raise_exception("applied-non-function", func);
        deregister_root(1);
        return NULL;
    }

    SET(thread, THR_FUNC, func);
    SET(thread, THR_CURR_GF, curr_gf);

    deregister_root(1);
    return NULL;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_function(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(function_class, NULL);

    AM("fork", func_fork, 1);
    AM("install-handler", func_install, 1);

    addprim("call/cc", func_callcc, 1);
    addprim("remove-handler", func_remove, 0);

    deregister_root(1);
}   

