/* $Id: integer.c,v 1.6 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "integer.h"
#include "prim.h"
#include "pair.h"
#include "thread.h"
#include "string.h"

void init_integer(void) {
    int_class = newclass(object_class, INT_SIZE, NULL);
    register_root(&int_class, 1);
}

/* Methods */

PRIVATE OBJECT integer_printstr(OBJECT i, OBJECT w) {
  char buf[128];
  sprintf(buf, "%ld", NUM(i));
  return newstring(buf);
}

PRIVATE OBJECT integer_add(OBJECT a, OBJECT b) {
    return MKNUM(NUM(a) + NUM(b));
}

PRIVATE OBJECT integer_sub(OBJECT a, OBJECT b) {
    return MKNUM(NUM(a) - NUM(b));
}

PRIVATE OBJECT integer_mul(OBJECT a, OBJECT b) {
    return MKNUM(NUM(a) * NUM(b));
}

PRIVATE OBJECT integer_div(OBJECT a, OBJECT b) {
    if (NUM(b) == 0) {
        raise_exception("division-by-zero", NULL);
        return NULL;
    }

    return MKNUM(NUM(a) / NUM(b));
}

PRIVATE OBJECT integer_modulo(OBJECT a, OBJECT b) {
    if (NUM(b) == 0) {
        raise_exception("division-by-zero", NULL);
        return NULL;
    }

    return MKNUM(NUM(a) % NUM(b));
}

PRIVATE OBJECT integer_and(OBJECT a, OBJECT b) {
    return MKNUM(NUM(a) & NUM(b));
}

PRIVATE OBJECT integer_or(OBJECT a, OBJECT b) {
  return MKNUM(NUM(a) | NUM(b));
}

PRIVATE OBJECT integer_xor(OBJECT a, OBJECT b) {
  return MKNUM(NUM(a) ^ NUM(b));
}

PRIVATE OBJECT integer_bin_len(OBJECT obj) {
    return MKNUM(0);
}

PRIVATE OBJECT integer_equalp(OBJECT a, OBJECT b) {
    return a == b ? true : false;
}

PRIVATE OBJECT integer_lp(OBJECT a, OBJECT b) {
    return NUM(a) < NUM(b) ? true : false;
}

PRIVATE OBJECT integer_gp(OBJECT a, OBJECT b) {
    return NUM(a) > NUM(b) ? true : false;
}

PRIVATE OBJECT integer_lep(OBJECT a, OBJECT b) {
    return NUM(a) <= NUM(b) ? true : false;
}

PRIVATE OBJECT integer_gep(OBJECT a, OBJECT b) {
    return NUM(a) >= NUM(b) ? true : false;
}

PRIVATE OBJECT integer_min(OBJECT a, OBJECT b) {
    return NUM(a) < NUM(b) ? a : b;
}

PRIVATE OBJECT integer_max(OBJECT a, OBJECT b) {
    return NUM(a) > NUM(b) ? a : b;
}

PRIVATE OBJECT integer_abs(OBJECT num) {
    return NUM(num) < 0 ? MKNUM(-NUM(num)) : num;
}

PRIVATE OBJECT integer_as_string(OBJECT num) {
  char s[80];

  sprintf(s, "%ld", NUM(num));
  return newstring(s);
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_integer(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(int_class, NULL);

    AM("print-string", integer_printstr, 2);
    AM("+", integer_add, 2);
    AM("-", integer_sub, 2);
    AM("*", integer_mul, 2);
    AM("/", integer_div, 2);
    AM("binary-and", integer_and, 2);
    AM("binary-or", integer_or, 2);
    AM("binary-xor", integer_xor, 2);
    AM("modulo", integer_modulo, 2);
    AM("binary-length", integer_bin_len, 1);
    AM("=", integer_equalp, 2);
    AM("<", integer_lp, 2);
    AM(">", integer_gp, 2);
    AM("<=", integer_lep, 2);
    AM(">=", integer_gep, 2);
    AM("min", integer_min, 2);
    AM("max", integer_max, 2);
    AM("abs", integer_abs, 1);
    AM("as-string", integer_as_string, 1);

    deregister_root(1);
}

