/* $Id: memory.h,v 1.3 1998/04/05 10:33:48 tonyg Exp $ */

#ifndef Memory_H
#define Memory_H

#include "config.h"

#include <setjmp.h>
#include <stdlib.h>
#include <stdio.h>

typedef unsigned int word;

#define PRIVATE static

typedef struct Object *OBJECT;
typedef struct Object {
    OBJECT next;            /* For linked list of ALL ALLOCED OBJECTS */

    struct {
        word mark : 1;
        word numidx : 15;
    } numidx;
    word numbin;

    OBJECT class;
    /* Here follow class-declared slots */
    /* Here follow variable (instance-determined) indexed slots */
    /* Here follow indexed binary data */
} Object;

#define NEXTOBJ(o)          ((o)->next)
#define SETNEXTOBJ(o, v)    ((o)->next = (v))

#define MARK(o)             ((o)->numidx.mark)
#define SETMARK(o, v)       ((o)->numidx.mark = (v))

#define NUMIDX(o)           ((o) ? (o)->numidx.numidx : 0)
#define SETNUMIDX(o, v)     ((o)->numidx.numidx = (v))

#define NUMBIN(o)           ((o) ? (o)->numbin : 0)
#define SETNUMBIN(o, v)     ((o)->numbin = (v))

/* Making tagged-pointer integers: */

#define MKNUM(v)        ((OBJECT) (((v) << 1) | 1))
#define NUM(o)          ((long) (o) >> 1)

/* Extracting and setting values of slots: */

#define CLASS(o)        ((o)->class)
#define SETCLASS(o, v)  ((o)->class = (v))

#define GET(o, n)       ((&CLASS(o))[(n) + 1])
#define SET(o, n, v)    ((&CLASS(o))[(n) + 1] = (v))

#define CLSSIZE(o)      ((word) NUM(GET(CLASS(o), CLS_NUMIVAR)))

#define IGET(o, n)      GET(o, (n) + CLSSIZE(o))
#define ISET(o, n, v)   SET(o, (n) + CLSSIZE(o), v)

#define BIDX(o, n)      ((char *) ((&CLASS(o)) + 1 +                    \
                                    CLSSIZE(o) + NUMIDX(o)) + (n))

#define BGET(o, n)      (*BIDX(o, n))
#define BSET(o, n, v)   (*BIDX(o, n) = (v))

/* Accessing an object's class */

#define GETCLASS(o)     (((o) == NULL) ? null_class :               \
                         ((word) (o) & 1) ? int_class : CLASS(o))

/* Globals for the system: */

extern int debug_flag;
extern volatile OBJECT signal_raised;    /* Nonnull if signal occurred */

extern OBJECT null_class, int_class, object_class;

#define OBJECT_SIZE     0   /* Size of an instance of <object> */

extern OBJECT true, false, undefined;

/* Error handling */

extern void fatal(char *format, ...);
extern void error(char *format, ...);

/* Memory allocation and deallocation */

extern void init_memory(long maxbytes, int dflag);

#define VECTTAB_SIZE    10

extern OBJECT all_objects;      /* All currently allocated objects */

extern void *getmem(word size);
extern void *growmem(void *oldblk, word oldsize, int incr);
extern void freemem(void *blk);

extern void register_root(OBJECT *root, int size);
    /* size is the number of roots in an array at this location */

extern void temp_register(OBJECT *root, int size);
extern void deregister_root(int n);
    /* deregisters the last n temporarily registered roots */

extern void gc(void);

extern OBJECT NewObject(OBJECT class, word numidx, word numbin);

/* Stuff global to _all_ objects: */

extern int subclass(OBJECT class, OBJECT super);  /* class subcls of super? */

#define instance(o, c)      subclass(GETCLASS(o), (c))

#endif

