/* $Id: object.c,v 1.6 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "object.h"
#include "prim.h"
#include "pair.h"
#include "thread.h"
#include "vector.h"
#include "string.h"

void init_object(void) {
}

/* Methods */

PRIVATE OBJECT object_printstr(OBJECT obj, OBJECT w) {
  return newstring("#<object>");
}

PRIVATE OBJECT object_raw_ref(OBJECT obj, OBJECT idx) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= CLSSIZE(obj)) {
        raise_exception("index-out-of-range", newvector(2, 1, obj, idx));
        return NULL;
    }

    return GET(obj, (word) num);
}

PRIVATE OBJECT object_raw_set(OBJECT obj, OBJECT idx, OBJECT val) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= CLSSIZE(obj)) {
        raise_exception("index-out-of-range", newvector(3, 1, obj, idx, val));
        return NULL;
    }

    SET(obj, (word) num, val);
    return val;
}

PRIVATE OBJECT object_idx_ref(OBJECT obj, OBJECT idx) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= NUMIDX(obj)) {
        raise_exception("index-out-of-range", newvector(2, 1, obj, idx));
        return NULL;
    }

    return IGET(obj, (word) num);
}

PRIVATE OBJECT object_idx_set(OBJECT obj, OBJECT idx, OBJECT val) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= NUMIDX(obj)) {
        raise_exception("index-out-of-range", newvector(3, 1, obj, idx, val));
        return NULL;
    }

    ISET(obj, (word) num, val);
    return val;
}

PRIVATE OBJECT object_bin_ref(OBJECT obj, OBJECT idx) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= NUMBIN(obj)) {
        raise_exception("index-out-of-range", newvector(2, 1, obj, idx));
        return NULL;
    }

    return MKNUM((unsigned char) BGET(obj, (word) num));
}

PRIVATE OBJECT object_bin_set(OBJECT obj, OBJECT idx, OBJECT val) {
    long num = (long) NUM(idx);

    if (num < 0 || num >= NUMBIN(obj)) {
        raise_exception("index-out-of-range", newvector(3, 1, obj, idx, val));
        return NULL;
    }

    BSET(obj, (word) num, (unsigned char) NUM(val));
    return MKNUM((unsigned char) NUM(val));
}

PRIVATE OBJECT object_inst(OBJECT obj, OBJECT cls) {
    return (instance(obj, cls) ? true : false);
}

PRIVATE OBJECT object_eq(OBJECT a, OBJECT b) {
    return (a == b ? true : false);
}

PRIVATE OBJECT object_raw_len(OBJECT obj) {
    return MKNUM(CLSSIZE(obj));
}

PRIVATE OBJECT object_idx_len(OBJECT obj) {
    return MKNUM(NUMIDX(obj));
}

PRIVATE OBJECT object_bin_len(OBJECT obj) {
    return MKNUM(NUMBIN(obj));
}

PRIVATE OBJECT object_objcls(OBJECT obj) {
    return GETCLASS(obj);
}

PRIVATE OBJECT object_hash_eq(OBJECT obj) {
  return MKNUM(NUM(obj));	/* Guaranteed to return any one */
				/* hash number for at most two */
				/* objects. */

  /* Note that this is an invalid way of returning a hash-for-eq value
     if the garbage collector is copying rather than mark and sweep... */
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_object(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(object_class, NULL);

    AM("print-string", object_printstr, 2);
    AM("raw-indexed-ref", object_raw_ref, 2);
    AM("raw-indexed-set!", object_raw_set, 3);
    AM("indexed-ref", object_idx_ref, 2);
    AM("indexed-set!", object_idx_set, 3);
    AM("binary-ref", object_bin_ref, 2);
    AM("binary-set!", object_bin_set, 3);
    AM("instance?", object_inst, 2);
    AM("eq?", object_eq, 2);
    AM("equal?", object_eq, 2);
    AM("raw-indexed-length", object_raw_len, 1);
    AM("indexed-length", object_idx_len, 1);
    AM("binary-length", object_bin_len, 1);
    AM("object-class", object_objcls, 1);
    AM("hash-for-eq", object_hash_eq, 1);
    AM("hash-for-equal", object_hash_eq, 1);

    deregister_root(1);
}
