/* $Id: pair.c,v 1.3 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"

OBJECT pair_class;

void init_pair(void) {
    pair_class = newclass(object_class, PAIR_SIZE, NULL);
    register_root(&pair_class, 1);
}

OBJECT cons(OBJECT car, OBJECT cdr) {
    OBJECT obj = NewObject(pair_class, 0, 0);

    SETCAR(obj, car);
    SETCDR(obj, cdr);

    return obj;
}

long list_length(OBJECT list) {
    long count = 0;

    while (list != NULL) {
        count++;
        list = CDR(list);
    }

    return count;
}

/* Methods */

PRIVATE OBJECT pair_car(OBJECT pair) {
    return CAR(pair);
}

PRIVATE OBJECT pair_cdr(OBJECT pair) {
    return CDR(pair);
}

PRIVATE OBJECT pair_setcar(OBJECT pair, OBJECT car) {
    SETCAR(pair, car);
    return car;
}

PRIVATE OBJECT pair_setcdr(OBJECT pair, OBJECT cdr) {
    SETCDR(pair, cdr);
    return cdr;
}

PRIVATE OBJECT pair_append(OBJECT a, OBJECT b) {
  OBJECT result = NULL;
  OBJECT tail = NULL;

  temp_register(&result, 1);

  while (a != NULL) {
    if (result == NULL)
      result = tail = cons(CAR(a), NULL);
    else {
      SETCDR(tail, cons(CAR(a), NULL));
      tail = CDR(tail);
    }

    a = CDR(a);
  }

  if (result == NULL)
    result = b;
  else
    SETCDR(tail, b);

  deregister_root(1);

  return result;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_pair(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(pair_class, NULL);

    addprim("cons", cons, 2);

    AM("car", pair_car, 1);
    AM("cdr", pair_cdr, 1);
    AM("set-car!", pair_setcar, 2);
    AM("set-cdr!", pair_setcdr, 2);
    AM("+", pair_append, 2);

    deregister_root(1);
}

