/* $Id: parse.c,v 1.3 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "buffer.h"
#include "scan.h"
#include "parse.h"
#include "symbol.h"
#include "pair.h"
#include "vector.h"

PARSER newparser(OBJECT (*scan_proc)(SCANSTATE scanner), SCANSTATE scanner) {
    PARSER p = getmem(sizeof(Parser));

    p->scan_proc = scan_proc;
    p->scanner = scanner;
    p->need_scan = 1;
    p->cache = NULL;

    temp_register(&p->cache, 1);

    return p;
}

void killparser(PARSER p) {
    deregister_root(1);

    freemem(p);
}

PRIVATE OBJECT check(PARSER p) {
    if (p->need_scan) {
        p->cache = p->scan_proc(p->scanner);
        p->need_scan = 0;
    }

    return p->cache;
}

PRIVATE void parse_drop(PARSER p) {
    if (p->need_scan)
        p->cache = p->scan_proc(p->scanner);

    p->need_scan = 1;
}

/* Parser proper */

PRIVATE OBJECT parse_list(PARSER p) {
    OBJECT org, prev;

    org = prev = NULL;

    temp_register(&org, 1);

    while (1) {
        if (check(p) == newsym(")")) {
            parse_drop(p);

            deregister_root(1);
            return org;
        }

        if (check(p) == newsym(".")) {
            parse_drop(p);

            if (prev == NULL) {	/* Dotted pair must have CAR */
	      org = newsym("parser-error");
	      org = prev = cons(org, NULL);
	    }

            SETCDR(prev, parse(p));

            if (check(p) != newsym(")"))
                    /* Close-paren expected after dotted list */
                ;
            else
                parse_drop(p);

            deregister_root(1);
            return org;
        }

        if (prev == NULL) {
	  org = parse(p);
	  org = prev = cons(org, NULL);
        } else {
	  SETCDR(prev, parse(p));
	  SETCDR(prev, cons(CDR(prev), NULL));
	  prev = CDR(prev);
        }

        if (CAR(prev) == undefined)
            break;  /* Unexpected end of input */
    }

    deregister_root(1);
    return org;
}

#define QCONS(str)      { \
                            parse_drop(p); \
			    R[0] = newsym(str); \
			    R[1] = parse(p); \
			    R[1] = cons(R[1], NULL); \
			    R[1] = cons(R[0], R[1]); \
			    deregister_root(1); \
			    return R[1]; \
                        }

OBJECT parse(PARSER p) {
  OBJECT R[2];

  if (check(p) == undefined) {
    parse_drop(p);
    return undefined;
  }

  if (check(p) == newsym("(")) {
    parse_drop(p);
    return parse_list(p);
  }

  if (check(p) == newsym(")")) {	/* Too many close-parens */
    parse_drop(p);
    return NULL;
  }

  R[0] = R[1] = NULL;
  temp_register(R, 2);

  if (check(p) == newsym("\'"))
    QCONS("quote")

  if (check(p) == newsym("`"))
    QCONS("quasiquote")

  if (check(p) == newsym(","))
    QCONS("unquote")

  if (check(p) == newsym(",@"))
    QCONS("unquote-splicing")

  if (check(p) == newsym("#(")) {
    parse_drop(p);
    R[0] = parse_list(p);
    R[0] = listtovect(R[0]);
    deregister_root(1);
    return R[0];
  }

  deregister_root(1);

  {
    OBJECT result = check(p);

    parse_drop(p);
    return result;
  }
}

