/* $Id: prim.c,v 1.4 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "symbol.h"
#include "gf.h"

OBJECT prim_class;

void init_prim(void) {
    prim_class = newclass(object_class, PRIM_SIZE, NULL);
    register_root(&prim_class, 1);
}

void init_meth_prim(void) {
}

OBJECT newprim(long argc, OBJECT name, OBJECT (*func)()) {
    OBJECT prim = NewObject(prim_class, 0, sizeof(OBJECT (*)()));

    SET(prim, PRIM_ARGC, MKNUM(argc));
    SET(prim, PRIM_NAME, name);
    * (OBJECT (**)()) BIDX(prim, 0) = func;

    return prim;
}

OBJECT (*getfunc(OBJECT prim))() {
    return * (OBJECT (**)()) BIDX(prim, 0);
}

void addmeth(char *name, OBJECT (*func)(), long argc, OBJECT classlist) {
  OBJECT R[2];

  R[0] = R[1] = NULL;
  temp_register(R, 2);

  R[0] = newsym(name);
  R[1] = GET(R[0], SYM_VALUE);

  if (R[1] == undefined) {
    R[1] = newgf(R[0]);
    SET(R[0], SYM_VALUE, R[1]);
  }

  R[0] = newprim(argc, R[0], func);
  addmethod(R[1], R[0], classlist);

  deregister_root(1);
}

void addprim(char *name, OBJECT (*func)(), long argc) {
    OBJECT sym = newsym(name);

    temp_register(&sym, 1);
    SET(sym, SYM_VALUE, newprim(argc, sym, func));
    deregister_root(1);
}

