/* $Id: stream.c,v 1.4 1998/04/05 10:33:48 tonyg Exp $ */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"
#include "symbol.h"
#include "string.h"
#include "thread.h"
#include "buffer.h"
#include "scan.h"
#include "parse.h"
#include "stream.h"

OBJECT stream_class;
OBJECT string_stream_class;

void init_stream(void) {
    stream_class = newclass(object_class, STREAM_SIZE, NULL);
    SET(newsym("<stream>"), SYM_VALUE, stream_class);

    string_stream_class = newclass(stream_class, STRING_STREAM_SIZE, NULL);
    SET(newsym("<string-stream>"), SYM_VALUE, string_stream_class);
}

/* Methods */

PRIVATE OBJECT stream_printstr(OBJECT str, OBJECT w) {
  return newstring("#<stream>");
}

PRIVATE OBJECT strstr_printstr(OBJECT str, OBJECT w) {
  char buf[128];
  sprintf(buf,
	  "#<string-stream %.40s>",
	  BIDX(GET(str, STRING_STREAM_STRING),
	       (word) NUM(GET(str, STRING_STREAM_POS))));
  return newstring(buf);
}

PRIVATE OBJECT strstr_initialize(OBJECT self, OBJECT source) {
    if (!instance(source, string_class))
        return undefined;

    SET(self, STRING_STREAM_STRING, source);
    SET(self, STRING_STREAM_POS, MKNUM(0));
    SET(self, STRING_STREAM_CACHE, NULL);

    return self;
}

PRIVATE OBJECT strstr_read_chars(OBJECT self, OBJECT count) {
    char *buf = NULL; 
    OBJECT result;
    OBJECT str;
    int wanted = (int) NUM(count);
    int nread, i, c, pos;

    if (wanted == 0)
        return NULL;

    buf = getmem(wanted + 1);
    i = 0;

    if (GET(self, STRING_STREAM_CACHE) != NULL) {
        buf[i++] = BGET(GET(self, STRING_STREAM_CACHE), 0);
        wanted--;
        SET(self, STRING_STREAM_CACHE, NULL);
    }

    str = GET(self, STRING_STREAM_STRING);
    pos = (int) NUM(GET(self, STRING_STREAM_POS));

    nread = (int) NUMBIN(str) - 1;
    nread -= pos;

    if (nread > wanted)
        nread = wanted;

    c = nread;

    while (c > 0) {
        buf[i++] = BGET(str, pos++);
        c--;
    }

    buf[i] = '\0';

    if (i == 0) {
        freemem(buf);
        return NULL;
    }

    SET(self, STRING_STREAM_POS, MKNUM(pos));

    result = NewObject(string_class, 0, nread + 1);
    memcpy(BIDX(result, 0), buf, nread + 1);

    freemem(buf);

    return result;
}

PRIVATE OBJECT strstr_seek(OBJECT self, OBJECT pos, OBJECT whence) {
    int p = (int) NUM(GET(self, STRING_STREAM_POS));
    int size = (int) NUMBIN(GET(self, STRING_STREAM_STRING)) - 1;

    SET(self, STRING_STREAM_CACHE, NULL);

    if (whence == newsym("cur"))
        p += (int) NUM(pos);
    else if (whence == newsym("end"))
        p = size + (int) NUM(pos);
    else
        p = (int) NUM(pos);

    if (p < 0)
        p = 0;
    else if (p > size)
        p = size;

    SET(self, STRING_STREAM_POS, MKNUM(p));

    return MKNUM(p);
}

PRIVATE OBJECT strstr_tell(OBJECT self) {
    return GET(self, STRING_STREAM_POS);
}

PRIVATE OBJECT strstr_eof(OBJECT self) {
    int pos = (int) NUM(GET(self, STRING_STREAM_POS));
    int size = NUMBIN(GET(self, STRING_STREAM_STRING)) - 1;

    if (pos == size && GET(self, STRING_STREAM_CACHE) == NULL)
        return true;
    else
        return false;
}

PRIVATE OBJECT strstr_ungetc(OBJECT self, OBJECT ch) {
    SET(self, STRING_STREAM_CACHE, ch);
    return true;
}

PRIVATE OBJECT strstr_flush(OBJECT self) {
    return true;
}

PRIVATE char strstr_peek(SCANSTATE s) {
    OBJECT self = (OBJECT) (s->source);

    if (GET(self, STRING_STREAM_CACHE) != NULL)
        return BGET(GET(self, STRING_STREAM_CACHE), 0);

    if (NUM(GET(self, STRING_STREAM_POS)) ==
        NUMBIN(GET(self, STRING_STREAM_STRING)) - 1)
            return EOF;

    return BGET(GET(self, STRING_STREAM_STRING),
                (word) NUM(GET(self, STRING_STREAM_POS)));
}

PRIVATE void strstr_drop(SCANSTATE s) {
    OBJECT self = (OBJECT) (s->source);

    if (GET(self, STRING_STREAM_CACHE) != NULL) {
        SET(self, STRING_STREAM_CACHE, NULL);
        return;
    }

    if (NUM(GET(self, STRING_STREAM_POS)) ==
        NUMBIN(GET(self, STRING_STREAM_STRING)) - 1)
            return;

    SET(self, STRING_STREAM_POS,
        MKNUM(NUM(GET(self, STRING_STREAM_POS)) + 1));
}

PRIVATE OBJECT strstr_read(OBJECT self) {
    SCANSTATE s = NULL;
    PARSER p = NULL;
    OBJECT obj = NULL;

    temp_register(&self, 1);
    temp_register(&obj, 1);

    s = newscanner(self, strstr_peek, strstr_drop);
    p = newparser(scan, s);

    obj = parse(p);

    if (obj == undefined)
        obj = GET(newsym("%%the-eof-object"), SYM_VALUE);

    killparser(p);
    killscanner(s);

    deregister_root(2);

    return obj;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)
#define AMS(n,f,a)  addmeth(n,f,a,cls)

void init_meth_stream(void) {
    OBJECT cl = NULL;
    OBJECT cls = NULL;

    temp_register(&cl, 1);
    temp_register(&cls, 1);

    cl = cons(stream_class, NULL);
    cls = cons(string_stream_class, NULL);

    AM("print-string", stream_printstr, 2);

    AMS("print-string", strstr_printstr, 2);
    AMS("initialize", strstr_initialize, 2);
    AMS("read-chars-from", strstr_read_chars, 2);
    AMS("stream-seek", strstr_seek, 3);
    AMS("stream-tell", strstr_tell, 1);
    AMS("stream-at-eof?", strstr_eof, 1);
    AMS("stream-ungetc", strstr_ungetc, 2);
    AMS("stream-flush", strstr_flush, 1);
    AMS("read-from", strstr_read, 1);

    deregister_root(2);
}

