/* $Id: symbol.c,v 1.8 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "symbol.h"
#include "function.h"
#include "prim.h"
#include "pair.h"
#include "string.h"

#include <string.h>
#include <ctype.h>

OBJECT symtab[SYMTAB_SIZE];

OBJECT symbol_class;

void init_symbol(void) {
  int i;

  symbol_class = NULL;
  register_root(&symbol_class, 1);
  symbol_class = newclass(object_class, SYM_SIZE, NULL);  /* No ivarnames! */

  for (i=0; i<SYMTAB_SIZE; i++)
    symtab[i] = NULL;
}

/* An implementation of hashpjw, originally written by P.J. Weinberger
   in a C compiler. Taken from "Compilers: Principles, Techniques and
   Tools" by Aho, Sethi and Ullman
                (Addison-Wesley 1986, ISBN 0-201-10194-7) */

unsigned long hash_str(char *string) {
    unsigned long hash = 0, g;

    if (string == NULL) return 0;

    while (*string) {
        hash = (hash << 4) + tolower(*string++);
        g = hash & 0xf0000000L;
        if (g) {
            hash = hash ^ (g >> 24);
            hash = hash ^ g;
        }
    }
    return hash;
}

OBJECT newsym(char *val) {
    word hash = (word) hash_str(val) % SYMTAB_SIZE;
    OBJECT branch = symtab[hash];

    while (branch != NULL) {
        if (!strcmp(BIDX(branch, 0), val))
            return branch;

        branch = GET(branch, SYM_NEXT);
    }

    branch = NewObject(symbol_class, 0, strlen(val) + 1);

    strcpy(BIDX(branch, 0), val);
    SET(branch, SYM_VALUE, undefined);

    register_symbol(branch);

    return branch;
}

void register_symbol(OBJECT sym) {
    word hash = (word) hash_str(BIDX(sym, 0)) % SYMTAB_SIZE;

    SET(sym, SYM_NEXT, symtab[hash]);
    symtab[hash] = sym;
}

/* Methods */

PRIVATE OBJECT symbol_defglb(OBJECT sym, OBJECT val) {
    SET(sym, SYM_VALUE, val);

    if (debug_flag)
        fprintf(stderr, "Defining global variable %s\n",
            BIDX(sym, 0));

    if (instance(val, function_class))
        SET(val, FUNC_NAME, sym);

    return val;
}

PRIVATE OBJECT symbol_boundp(OBJECT sym) {
    return GET(sym, SYM_VALUE) == undefined ? false : true;
}

PRIVATE OBJECT symbol_printstr(OBJECT sym, OBJECT w) {
  return newstring(BIDX(sym, 0));
}

PRIVATE OBJECT symbol_to_str(OBJECT sym) {
    return newstring(BIDX(sym, 0));
}

PRIVATE OBJECT symbol_identity(OBJECT sym) {
  return sym;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_symbol(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(symbol_class, NULL);

    addprim("define-global-variable", symbol_defglb, 2);
    addprim("global-variable-bound?", symbol_boundp, 1);

    AM("print-string", symbol_printstr, 2);
    AM("as-string", symbol_to_str, 1);
    AM("as-symbol", symbol_identity, 1);
    
    deregister_root(1);
}

